ccfeh dr_irk2
      include 'gni_irk2.f'
      include 'problem.f'
C ---
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (NDIM=100)
      DIMENSION P(NDIM),Q(NDIM),PEX(NDIM),QEX(NDIM),IPAR(20),RPAR(20)
      REAL TIME0,TIME1
      EXTERNAL EQUA,SOLFIX
C --- CHOOSE THE PROBLEM
C  IPROB = 1 : KEPLER PROBLEM, ECCENTRICITY IN RPAR(1)
C  IPROB = 2 : HARMONIC OSCILLATOR
C  IPROB = 3 : PENDULUM
C  IPROB = 4 : OUTER SOLAR SYSTEM
      IPROB=4
      IPAR(11)=IPROB
      IF (IPROB.EQ.1) RPAR(11)=0.6D0
      CALL PDATA(X,XEND,NDIM,N,Q,P,QEX,PEX,RPAR,IPAR)
C --- CHOOSE THE THE METHOD
C --- GAUSS METHOD OF ORDER 2*METH
      METH=6
      WRITE (6,*) '     METHOD, PROBLEM  ',METH,IPROB
      H=1.0D2
      NSTEP=(XEND-X)/H
C --- CALL OF THE METHOD
      DO I=1,10
        RPAR(I)=0.0D0
        IPAR(I)=0
      END DO
      IPAR(12)=0
      IOUT=1
      CALL CPU_TIME(TIME0)
      CALL GNI_IRK2(N,EQUA,NSTEP,X,P,Q,XEND,
     &                  METH,SOLFIX,IOUT,RPAR,IPAR)
      CALL CPU_TIME(TIME1)
C --- STATISTICS
      NFCN=IPAR(12)
      ERR=0.0D0
      DO I=1,N
        ERR=ERR+(Q(I)-QEX(I))**2+(P(I)-PEX(I))**2
      END DO
      ERR=SQRT(ERR)
      WRITE (6,90) NFCN,TIME1-TIME0,ERR,RPAR(13)
 90   FORMAT (1X,I8,F7.2,1X,2E24.16)
      STOP
      END
C
      SUBROUTINE SOLFIX (NR,XOLD,X,P,Q,N,IRTRN,RPAR,IPAR)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION Q(N),P(N)
      DIMENSION IPAR(20),RPAR(20)
      CALL HAMILTON (N,X,Q,P,HAMIL,RPAR,IPAR)
      IF (NR.EQ.0) THEN
        RPAR(12)=HAMIL
        RPAR(13)=0.0D0
      ELSE
        RPAR(13)=MAX(RPAR(13),ABS(RPAR(12)-HAMIL))
      END IF
      RETURN
      END
