C-----------------------------------------------------------------------
      SUBROUTINE GNI_COMP(BASIC,N,FCN,NSTEP,X,P,Q,XEND,
     &                    METHC,SOLFIX,IOUT,RPAR,IPAR)
C-----------------------------------------------------------------------
C                 VERSION OF SEPTEMBER 4,2002  
C  E-MAIL CONTACT ADDRESS : Ernst.Hairer@math.unige.ch
C-----------------------------------------------------------------------
C  SYMMETRIC COMPOSITION OF SYMMETRIC METHODS
C  DESCRIBED IN SECTIONS II.4, V.3 OF THE BOOK:
C
C      E. HAIRER, C. LUBICH, G. WANNER, GEOMETRIC NUMERICAL INTEGRATION,
C         STRUCTURE-PRESERVING ALGORITHMS FOR ODES.
C         SPRINGER SERIES IN COMPUT. MATH. 31, SPRINGER 2002.
C
C  AND IN THE PUBLICATION
C
C      E. HAIRER, M. HAIRER, GNI-CODES - MATLAB PROGRAMS FOR
C         GEOMETRIC NUMERICAL INTEGRATION.
C
C  INPUT..
C     BASIC       NAME (EXTERNAL) OF BASIC INTEGRATION METHOD:
C                    BASIC (N,X,P,Q,EP,EQ,FCN,HA,HB,HC,FIRST,LAST,RPAR,IPAR) 
C                    REAL*8 P(N),Q(N),EP(N),EQ(N)
C                    LOGICAL FIRST,LAST
C                 "STVERL" SOLVES SECOND ORDER ODES Q'' = F(X,Q)
C
C     N           DIMENSION OF Q AND F(Q) 
C
C     FCN         NAME (EXTERNAL) OF SUBROUTINE COMPUTING F(X,Q):
C                    SUBROUTINE FCN(N,X,Q,F,RPAR,IPAR)
C                    REAL*8 Q(N),F(N)
C                    F(1)=...   ETC.
C
C     NSTEP       NUMBER OF INTEGRATION STEPS
C                    CONSTANT STEP SIZE, H=(XEND-X)/NSTEP
C
C     X           INITIAL X-VALUE
C     P(N)        INITIAL VELOCITY VECTOR
C     Q(N)        INITIAL POSITION VECTOR
C     XEND        FINAL X-VALUE
C
C     METHC       ORDER AND STAGES OF THE COMPOSITION METHOD
C                 E.G., 817 IS A METHOD OF ORDER 8 WITH 17 STAGES
C                 POSSIBLE VALUES : 21,43,45,67,69,815,817,1033
C
C     SOLFIX      NAME (EXTERNAL) OF SUBROUTINE PROVIDING THE
C                 NUMERICAL SOLUTION DURING INTEGRATION. 
C                 IF IOUT=1, IT IS CALLED AFTER EVERY STEP.
C                 SUPPLY A DUMMY SUBROUTINE IF IOUT=0. 
C                    SUBROUTINE SOLFIX (NR,XOLD,X,P,Q,N,IRTRN,RPAR,IPAR)
C                    DOUBLE PRECISION X,Y(N),CONT(LRC)
C                      ....  
C                 SOLFIX FURNISHES THE SOLUTION "Q,P" AT THE NR-TH
C                    GRID-POINT "X" (INITIAL VALUE FOR NR=0).
C                 "XOLD" IS THE PRECEEDING GRID-POINT.
C                 "IRTRN" SERVES TO INTERRUPT THE INTEGRATION. IF IRTRN
C                    IS SET <0, RETURN TO THE CALLING PROGRAM.
C     IOUT        SWITCH FOR CALLING THE SUBROUTINE SOLFIX:
C                    IOUT=0: SUBROUTINE IS NEVER CALLED
C                    IOUT=1: SUBROUTINE IS AVAILABLE FOR OUTPUT.
C
C     RPAR(LR)    REAL PARAMETER ARRAY; LR MUST BE AT LEAST LR=10
C                    RPAR(1),...,RPAR(10) SERVE AS PARAMETERS FOR
C                    THE CODE. FURTHER VALUES CAN BE USED FOR DEFINING
C                    PARAMETERS IN THE PROBLEM
C     IPAR(LI)    INTEGER PARAMETER ARRAY; LI MUST BE AT LEAST LI=10
C                    IPAR(1),...,IPAR(10) SERVE AS PARAMETERS FOR
C                    THE CODE. FURTHER VALUES CAN BE USED FOR DEFINING
C                    PARAMETERS IN THE PROBLEM
C
C  OUTPUT..
C     P(N)        SOLUTION (VELOCITY) AT XEND
C     Q(N)        SOLUTION (POSITION) AT XEND
C-----------------------------------------------------------------------
C     SOPHISTICATED SETTING OF PARAMETERS 
C-----------------------------------------------------------------------
C    NONE
C-----------------------------------------------------------------------
      PARAMETER (NDGL=500,NSD=100)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION P(N),Q(N),EP(NDGL),EQ(NDGL)
      DIMENSION GAM(NSD),HG(NSD),HGP(NSD)
      DIMENSION IPAR(*),RPAR(*)
      LOGICAL FIRST,LAST
      EXTERNAL FCN
      HH=(XEND-X)/NSTEP
C --- PREPARE THE COEFFICIENTS
      IF (METHC.NE.21.AND.METHC.NE.43.AND.METHC.NE.45.AND.METHC.NE.67
     &  .AND.METHC.NE.69.AND.METHC.NE.815.AND.METHC.NE.817
     &  .AND.METHC.NE.1033.AND.METHC.NE.1034) THEN
        WRITE (6,*) ' NO METHOD AVAILABLE FOR METHC = ',METHC
        RETURN
      END IF
      CALL COMPCO (METHC,NGAM,GAM)
            DO IGAM=1,NGAM
        HG(IGAM)=HH*GAM(IGAM)
      END DO
      HGP(1)=HG(1)/2.0D0
      DO IGAM=2,NGAM
        HGP(IGAM)=(HG(IGAM)+HG(IGAM-1))/2.0D0
      END DO
      HGP(NGAM+1)=HG(NGAM)/2.0D0
      HFL=HGP(1)+HGP(NGAM+1)
      IF (IOUT.NE.0) CALL SOLFIX (0,X,X,P,Q,N,IRTRN,RPAR,IPAR)
      FIRST=.TRUE.
      LAST=.FALSE.
C --- THE BIG LOOP
      DO ISTEP=1,NSTEP
        X=X+HH
        DO IGAM=1,NGAM-1
          CALL BASIC (N,X,P,Q,EP,EQ,FCN,HGP(IGAM),HG(IGAM),
     &                HGP(IGAM+1),FIRST,LAST,RPAR,IPAR) 
          FIRST=.FALSE.
        END DO
        IF (IOUT.NE.0) THEN
          LAST=.TRUE.
          CALL BASIC (N,X,P,Q,EP,EQ,FCN,HGP(NGAM),HG(NGAM),
     &                HGP(NGAM+1),FIRST,LAST,RPAR,IPAR) 
          CALL SOLFIX (ISTEP,X-HH,X,P,Q,N,IRTRN,RPAR,IPAR)
          IF (ISTEP.EQ.NSTEP.OR.IRTRN.LT.0) RETURN
          FIRST=.TRUE.
          LAST=.FALSE.
        ELSE
          IF (ISTEP.EQ.NSTEP) THEN
            LAST=.TRUE.
            CALL BASIC (N,X,P,Q,EP,EQ,FCN,HGP(NGAM),HG(NGAM),
     &                  HGP(NGAM+1),FIRST,LAST,RPAR,IPAR) 
            RETURN
          ELSE
            CALL BASIC (N,X,P,Q,EP,EQ,FCN,HGP(NGAM),HG(NGAM),
     &                  HFL,FIRST,LAST,RPAR,IPAR)
            FIRST=.FALSE.
          END IF
        END IF
      END DO
      RETURN
      END
C
      SUBROUTINE STVERL (N,X,P,Q,EP,EQ,FCN,HA,HB,HC,
     &                   FIRST,LAST,RPAR,IPAR) 
C--- STOERMER/VERLET FOR SECOND ORDER EQUATIONS
C--- A SUBROUTINE FCN(N,X,Q,F) HAS TO PROVIDED
      PARAMETER (NDGL=500)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION P(N),Q(N),EP(N),EQ(N),F(NDGL)
      DIMENSION IPAR(*),RPAR(*)
      LOGICAL FIRST,LAST
      IF (FIRST) THEN
        DO I=1,N
          TEMP=Q(I)
          EQ(I)=HA*P(I)
          Q(I)=TEMP+EQ(I)
          EQ(I)=EQ(I)+(TEMP-Q(I))
        END DO
      END IF
      CALL FCN(N,X,Q,F,RPAR,IPAR)
        DO I=1,N
          TEMP=P(I)
          EP(I)=EP(I)+HB*F(I)
          P(I)=TEMP+EP(I)
          EP(I)=EP(I)+(TEMP-P(I))
        END DO
        DO I=1,N
          TEMP=Q(I)
          EQ(I)=EQ(I)+HC*P(I)
          Q(I)=TEMP+EQ(I)
          EQ(I)=EQ(I)+(TEMP-Q(I))
        END DO
      RETURN
      END
C
      SUBROUTINE COMPCO (METHC,NGAM,GAM) 
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 GAM(100)
      IF (METHC.EQ.21) THEN
C --- BASIC METHOD, NO COMPOSITION
        NGAM=1
        GAM(1)=1.0D0
        RETURN
      END IF
      IF (METHC.EQ.43) THEN
C --- YOSHIDA (1990)
        NGAM=3
        QR2=2.0D0**(1.0D0/3.0D0)
        GAM(1)=1.0D0/(2.0D0-QR2)
        GAM(2)=-QR2*GAM(1)
      END IF
      IF (METHC.EQ.45) THEN
C --- SUZUKI (1990)
        NGAM=5
        QR4=4.0D0**(1.0D0/3.0D0)
        GAM(1)=1.0D0/(4.0D0-QR4)
        GAM(2)=GAM(1)
        GAM(3)=-QR4*GAM(1)
      END IF
      IF (METHC.EQ.67) THEN
C --- YOSHIDA (1990)
        NGAM=7
        GAM(1)= 0.78451361047755726381949763D0
        GAM(2)= 0.23557321335935813368479318D0
        GAM(3)=-1.17767998417887100694641568D0
        GAM(4)= 1.31518632068391121888424973D0
      END IF
      IF (METHC.EQ.69) THEN
C --- KAHAN & LI (1997)
        NGAM=9
        GAM(1)= 0.39215846226558135393725811D0
        GAM(2)= 0.33260288849639382848984234D0
        GAM(3)=-0.70624607359230088534941023D0
        GAM(4)= 0.08221272729243641010472095D0
        GAM(5)= 0.79854399107577858563517766D0
      END IF
      IF (METHC.EQ.815) THEN
C --- SUZUKI & UMENO (1993)
        NGAM=15
        GAM(1)= 0.74167036435061295344822780D0
        GAM(2)=-0.40910082580003159399730010D0
        GAM(3)= 0.19075471029623837995387626D0
        GAM(4)=-0.57386247111608226665638773D0
        GAM(5)= 0.29906418130365592384446354D0
        GAM(6)= 0.33462491824529818378495798D0
        GAM(7)= 0.31529309239676659663205666D0
        GAM(8)=-0.79688793935291635401978884D0
      END IF
      IF (METHC.EQ.817) THEN
C --- KAHAN & LI (1997)
        NGAM=17
        GAM(1)= 0.13020248308889008087881763D0
        GAM(2)= 0.56116298177510838456196441D0
        GAM(3)=-0.38947496264484728640807860D0
        GAM(4)= 0.15884190655515560089621075D0
        GAM(5)=-0.39590389413323757733623154D0
        GAM(6)= 0.18453964097831570709183254D0
        GAM(7)= 0.25837438768632204729397911D0
        GAM(8)= 0.29501172360931029887096624D0
        GAM(9)=-0.60550853383003451169892108D0
      END IF
      IF (METHC.EQ.1033) THEN
C --- HAIRER, LUBICH & WANNER (2002)
        NGAM=33
        GAM( 1)= 0.09040619368607278492161150D0
        GAM( 2)= 0.53591815953030120213784983D0
        GAM( 3)= 0.35123257547493978187517736D0
        GAM( 4)=-0.31116802097815835426086544D0
        GAM( 5)=-0.52556314194263510431065549D0
        GAM( 6)= 0.14447909410225247647345695D0
        GAM( 7)= 0.02983588609748235818064083D0
        GAM( 8)= 0.17786179923739805133592238D0
        GAM( 9)= 0.09826906939341637652532377D0
        GAM(10)= 0.46179986210411860873242126D0
        GAM(11)=-0.33377845599881851314531820D0
        GAM(12)= 0.07095684836524793621031152D0
        GAM(13)= 0.23666960070126868771909819D0
        GAM(14)=-0.49725977950660985445028388D0
        GAM(15)=-0.30399616617237257346546356D0
        GAM(16)= 0.05246957188100069574521612D0
        GAM(17)= 0.44373380805019087955111365D0
      END IF
      IF (METHC.EQ.1034) THEN
C --- MARK SOFRONIOU & GIULIA SPALETTA (2003)
        NGAM=33
        GAM( 1)= 0.070711261586085399079302771810203D0
        GAM( 2)= 0.090342080937267568345577914389234D0
        GAM( 3)= 0.14103133297152486103524322594476D0
        GAM( 4)= 0.40206004554029767537357060971803D0
        GAM( 5)=-0.30239722849131075165735249848238D0
        GAM( 6)=-0.22462355658241460137093154363351D0
        GAM( 7)= 0.061496988956063121940380707068411D0
        GAM( 8)= 0.11346847775740802675296685287062D0
        GAM( 9)= 0.23654672241381781124636015203490D0
        GAM(10)= 0.27211409645898977643699556260890D0
        GAM(11)= 0.076129418470277234386530906651024D0
        GAM(12)=-0.18543093454238185309165565783301D0
        GAM(13)=-0.46495110925607623804616342747217D0
        GAM(14)= 0.10423014962104084592532590279051D0
        GAM(15)= 0.13621181452383232935841998116651D0
        GAM(16)=-0.27010275720513252644976102610064D0
        GAM(17)= 0.48632639368142264147037913293721D0
      END IF
      DO I=1,NGAM/2
        GAM(NGAM+1-I)=GAM(I)
      END DO
      RETURN
      END
