
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                  C
C  DRIVER EXAMPLE FOR THE GGG PICTURE ENVIRONMENT  C 
C                                                  C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

      DIMENSION XDES(1000),YDES(1000)
C ------- memory for lines and fillings -------

      COMMON/SIZES/DIM(4)
      DATA DIM/6.,5.,1.,1./
C --------- Size of the pictures in cm and distances ------

      CALL BEGIN_GGG('driverGGG')
C ------ INITIALISATION GRAPHICS --------
C  The statement CALL BEGIN_GGG('name')  initiates
C  the environment, which will produce a ps-file
C  'name.ps' and a LaTeX input file 'name.inp'
C  to be inserted as follows in the LaTeX file:
C  \begin{figure}[h]
C    \centering
C     \input name.inp
C    \caption{Test for GGGnugnat}\label{Gnugnat}
C  \end{figure}

      XMIN=0.
      XMAX= 1.
      YMIN=0.
      YMAX=1.
C ----- LOCAL COORDINATE LIMITS ----

      CALL MICKEY_MOUSE(1,1,XMIN,XMAX,YMIN,YMAX)

C ---- place picture on paper ------
C  CALL MICKEY_MOUSE(I,J,XMIN,XMAX,YMIN,YMAX) places a picture
C  of size SIZE(1),SIZE(2) cm on the paper like in a Mickey Mouse
C  comics. Can be used several times. I,J are the positions
C  like the indices of a matrix.
C  XMIN,XMAX,YMIN,YMAX are the bounds of the local coordinates.
C  SIZE(3),SIZE(4) are the distances between individual pictures.

      CALL FRAME
C ----- makes a frame ------


      XDES(1)=0.5
      YDES(1)=0.2
      XDES(2)=0.9
      YDES(2)=0.2
      XDES(3)=0.9
      YDES(3)=0.6
      XDES(4)=0.7
      YDES(4)=0.8
      XDES(5)=0.5
      YDES(5)=0.6
      CALL CLOSE_FILL(XDES,YDES,5,0.5,.TRUE.)

C ----- fills a surface -----
C  CALL CLOSE_FILL(XDES,YDES,NDES,GREY,.TRUE.) fills the surface
C  delimited by XDES(I),YDES(I),I=1,NDES with grey tone. GREY 
C  is the brightness (0=black, 1=white). If the logical .TRUE.
C  is replaced by .FALSE., there is no boundary line drawn. 

 
      XINCR=0.2
      KX=2
      CALL AXEX(0.,0.,XMIN,XMAX,XINCR,KX)
      IDIGIT=1
      CALL LABEL_X(0.,0.,XMIN,XMAX,XINCR,IDIGIT)
      YINCR=0.5
      KY=5
      CALL AXEY(0.,0.,0.01,YMAX,YINCR,KY)
      IDIGIT=1
      CALL LABEL_Y(0.,0.,0.1,YMAX,YINCR,IDIGIT)

C ----- drawing the axes -------
C  CALL AXEX(XORIG,YORIG,XMIN,XMAX,XINCR,KX) draws x-axix with
C  XORIG,YORIG position of origin, XMIN,XMAX delimiters, XINCR
C  distance of large graduations, KX number of subgraduations.
C  CALL LABEL_X(XORIG,YORIG,XMIN,XMAX,XINCR,IDIGIT) writes labels,
C  IDIGIT is number of digits,

      CALL THICK_PIXEL(15)
      CALL LINE(0.45,0.6,0.7,0.85)
      CALL LINE(0.95,0.6,0.7,0.85)
      CALL THICK_PIXEL(30)
      CALL LINE(0.6,0.75,0.6,0.85)

C ----- drawing thick lines ----
C  CALL THICK_PIXEL(ITHICK) makes all subsequent lines 
C  ITHICK pixels thick.  
C  CALL LINE(XB,YB,XE,YE) draws a line connecting XB,YB with XE,YE.

      NDES=101
      DO IX=1,NDES
         DESM1=NDES-1
         X=0.1+0.7*(IX-1)/DESM1
         Y=0.15+0.1*SIN(20.*X)
         XDES(IX)=X
         YDES(IX)=Y
      END DO
      CALL THICK_PIXEL(6)
      CALL LING(XDES,YDES,NDES)

C ----- drawing a curve -------
C  CALL LING(XDES,YDES,NDES) connects NDES points with
C  given coordinates XDES(I),YDES(I),I=1,NDES.


      CALL THICK_PIXEL(4)
      Y=0.15+0.1*SIN(20.*0.8)
      CALL BUBBLE(0.8,Y,1.2,1.,'circle')

C ----- draws a symbol -------
C  CALL BUBBLE(X,Y,AMM,GREY,SYM): X,Y is the position,
C  AMM size approximately in mm, GREY (between 0 and 1)
C  brightness of filling, SYM form of symbol with many choices:
C  'circle','square','losange','xstar','pstar','utri','dtri','umtri',
C  'dmtri','hardy','laurel','mpent','mhex','pent','hex','mmhex'.


      CALL RGB_BUBBLE(0.2,0.7,8.,1.,0.5,0.,'square')

C ---- a colored symbol ------
C  the parameter GREY in BUBBLE is replaced by three
C  "red,green,blue" brightness values.


      CALL TEXT_LATEX_W(.7,.55,.5,.5,'$E=mc^2$')
      CALL TEXT_LATEX(0.1,0.25,0.,0.,'important formula')

C ------ write LaTeX formulas inside the picture ----
C  CALL TEXT_TEX(X,Y,ALAM,AMU,CHAR) writes LaTeX formula CHAR
C  at position X,Y. The parameters ALAM,AMU are the relative
C  coordinates (between 0 and 1) of the position point X,Y
C  inside the box and allow all types of centering.
C  Values outside the interval [0,1] are also possible.
C  CALL TEXT_TEX_W(X,Y,ALAM,AMU,CHAR) puts the formula
C  inside a white box.  


      CALL THICK_PIXEL(6)
      CALL ARROW(0.4,0.35,0.6,0.5,3.)

C ----- draw an arrow -----
C  CALL ARROW(XB,YB,XE,YE,AMM) has same arguments as LINE, with
C  AMM indicating size of arrow tip.


      CALL GREATER_BOUNDINGBOX(0.75,0.5,0.6,0.4)
 
      CALL COLOR_BOUNDINGBOX('yellow')
C      CALL RGB_COLOR_BOUNDINGBOX(1.,0.9,0.6)

c ---- correct bounding box (LEFT,RIGHT,DOWN,UP; IN CM)----
C  for fine adjustment of the picture inside the text


      CALL END_GGG

C ---- and that's the end -----
C  writes the necessary marcos and produces final files


      STOP
      END



