C ----- ETUDE DES RACINES DE LA METHODE ADAMS-4 ----
      include 'horse_make.f'
      include 'ddeflat.f'
        IMPLICIT COMPLEX(Z)
        DIMENSION XDES(999),YDES(999)
        DIMENSION XDESH(999),YDESH(999)
        DIMENSION XDES1(999),YDES1(999)
        DIMENSION XDES2(999),YDES2(999)
        DIMENSION XDES3(999),YDES3(999)
        DIMENSION XDES4(999),YDES4(999)
        DIMENSION ZDES1(999),ZDES2(999),ZDES3(999),ZDES4(999)
        DIMENSION ZA(0:50),ZROOT(50)
       CALL BEGIN_GGG('adams4')
       DO  IPIC=1,2
       CALL THICK_PIXEL(2)
C ###### FIRST PICTURE #########
       FACTOR=4.14634
       IF(IPIC.EQ.1)THEN
        XMIN=-0.45
        XMAX= 0.45
        YMIN=-0.95
        YMAX=0.95
         XDIM1=FACTOR*0.9
         XINT=0.3
         YDIM1=FACTOR*1.9
         PAPX1=0.
         PAPX2=PAPX1+XDIM1
         PAPY1=(2.38-1.9)*FACTOR/2.
         PAPY2=PAPY1+YDIM1
        CALL PAPER_CORNERS(PAPX1,PAPY1,PAPX2,PAPY2)
        CALL XY_LIMITS(XMIN,XMAX,YMIN,YMAX)
       END IF
C ------- CALCUL DES RACINES -------
C ###### SECOND PICTURE #########
       IF(IPIC.EQ.2)THEN
        XMIN=-1.19
        XMAX= 1.19
        YMIN=-1.19
        YMAX=1.19
         XDIM2=2.38*FACTOR
         YDIM2=2.38*FACTOR
         WRITE(6,*)'  YDIM2=',YDIM2 
         PAPX1=XDIM1+XINT
         PAPX2=PAPX1+XDIM2
         WRITE(6,*)'  PAPX2=',PAPX2 
         PAPY1=0.
         PAPY2=PAPY1+YDIM2
        CALL PAPER_CORNERS(PAPX1,PAPY1,PAPX2,PAPY2)
        CALL XY_LIMITS(XMIN,XMAX,YMIN,YMAX)
       END IF
C ------- REGION GAUCHE DE 0 -------
       RECDEL=0.44
       NREC=32
       AREC=NREC
       CALL THICK_PIXEL(0)
       DO IX=1,NREC
         XREC=-RECDEL*(IX-1.)/AREC
         DO ISIG=-1,1,2
           DO IY=1,NREC
C            IF(IY.NE.1.OR.IX.NE.1)THEN
             YREC=ISIG*RECDEL*(IY-0.5)/AREC
             AMM=0.15
             ZMU=CMPLX(XREC,YREC)
             ZA(0)=9./24.*ZMU
             ZA(1)=-37./24.*ZMU
             ZA(2)=59./24.*ZMU
             ZA(3)=-1.-55./24.*ZMU
             ZA(4)=1.
             CALL DEFLAT(4,ZA,ZROOT)
             RMAX=0.
             DO IROOT=1,4
              RMAX=MAX(RMAX,ABS(ZROOT(IROOT)))
             END DO
             IF(RMAX.LE.1.)THEN
              IF(IPIC.EQ.1)THEN
               CALL BUBBLE(XREC,YREC,AMM,0.,'circle')
              ELSE
               DO IROOT=1,4
                 XPOS=REAL(ZROOT(IROOT))
                 YPOS=AIMAG(ZROOT(IROOT))
                 CALL BUBBLE(XPOS,YPOS,AMM,0.,'circle')
               END DO
              END IF
C             END IF
            END IF
           END DO
         END DO
       END DO
C ------ THE WHITE HORSE ------
      CALL THICK_PIXEL(3)
      CALL HORSE_MAKE(0.,0.,1.,XDES,YDES,NDES)
C------ ROTATE -------
C      PHI=-0.18
      PHI=-0.12
      DO I=1,NDES
       XXX=COS(PHI)*XDES(I)-SIN(PHI)*YDES(I)
       YYY=SIN(PHI)*XDES(I)+COS(PHI)*YDES(I)
       XDES(I)=XXX
       YDES(I)=YYY
      END DO
C --- SHIFT ---- 
C      XCEN=-0.104
C      YCEN=0.03
C      FSCALE=0.2 
      XCEN=-0.125
      YCEN=0.02
      FSCALE=0.20 
      DO I=1,NDES
       XDES(I)=XCEN+FSCALE*XDES(I)
       YDES(I)=(YCEN+FSCALE*YDES(I))*1.8
      END DO
      IF(IPIC.EQ.1)THEN
        CALL CLOSE_FILL(XDES,YDES,NDES,1.,.TRUE.)
      ELSE
C ----- CALCULER LES 4 RACINES -------
       ZMU=CMPLX(XDES(1),YDES(1))
       ZA(0)=9./24.*ZMU
       ZA(1)=-37./24.*ZMU
       ZA(2)=59./24.*ZMU
       ZA(3)=-1.-55./24.*ZMU
       ZA(4)=1.
       CALL DEFLAT(4,ZA,ZROOT)
       ZDES1(1)=ZROOT(1)
       ZDES2(1)=ZROOT(2)
       ZDES3(1)=ZROOT(3)
       ZDES4(1)=ZROOT(4)
       DO I=2,NDES
        ZMU=CMPLX(XDES(I),YDES(I))
        ZR=ZDES1(I-1)
        CALL NEWTON(ZMU,ZR)
        ZDES1(I)=ZR
        ZR=ZDES2(I-1)
        CALL NEWTON(ZMU,ZR)
        ZDES2(I)=ZR
        ZR=ZDES3(I-1)
        CALL NEWTON(ZMU,ZR)
        ZDES3(I)=ZR
        ZR=ZDES4(I-1)
        CALL NEWTON(ZMU,ZR)
        ZDES4(I)=ZR
       END DO
       DO I=1,NDES
         XDES1(I)=REAL(ZDES1(I))
         YDES1(I)=AIMAG(ZDES1(I))
         XDES2(I)=REAL(ZDES2(I))
         YDES2(I)=AIMAG(ZDES2(I))
         XDES3(I)=REAL(ZDES3(I))
         YDES3(I)=AIMAG(ZDES3(I))
         XDES4(I)=REAL(ZDES4(I))
         YDES4(I)=AIMAG(ZDES4(I))
        END DO
        CALL CLOSE_FILL(XDES1,YDES1,NDES,1.,.TRUE.)
        CALL CLOSE_FILL(XDES2,YDES2,NDES,1.,.TRUE.)
        CALL CLOSE_FILL(XDES3,YDES3,NDES,1.,.TRUE.)
        CALL CLOSE_FILL(XDES4,YDES4,NDES,1.,.TRUE.)
       END IF
C ------ CALCUL DE LA ROOT LOCUS CURVE -----
       CALL THICK_PIXEL(8)
       NDES=401
       DO IX=1,NDES
          DESM1=NDES-1
          T=2.*3.14159265*(IX-1)/DESM1
          X=COS(T)
          Y=SIN(T)
          XDES(IX)=X
          YDES(IX)=Y
       END DO
       IF(IPIC.EQ.1)THEN
        DO I=1,NDES
         CALL ADVANCE(XDES(I),YDES(I),XDES(I),YDES(I))
        END DO
       END IF
        CALL LING(XDES,YDES,NDES)
C ------- GRILLAGE ORTHOGONAL ANGULAIRE ---------
       CALL THICK_PIXEL(0)
       DGRIL=0.18
       NGRIL=4
       AGRIL=NGRIL
       DO IGRIL=1,NGRIL
         RAD=1.+DGRIL*IGRIL/AGRIL
         NDES=401
         DO IX=1,NDES
           DESM1=NDES-1
           T=2.*3.14159265*(IX-1)/DESM1
           X=RAD*COS(T)
           Y=RAD*SIN(T)
           XDES(IX)=X
           YDES(IX)=Y
         END DO
         IF(IPIC.EQ.1)THEN
          DO I=1,NDES
           CALL ADVANCE(XDES(I),YDES(I),XDES(I),YDES(I))
          END DO
         END IF
         CALL LING(XDES,YDES,NDES)
       END DO 
C ------- GRILLAGE ORTHOGONAL RADIAL ---------
       NPHI=6.3*NGRIL/DGRIL
       WRITE(6,*)'  NPHI=',NPHI
       APHI=NPHI
       DO IPHI=1,NPHI
         T=IPHI*2.*3.14159265/APHI
         NDES=12
         ADES=NDES-1
         DO IDES=1,NDES
           RAD=1.+DGRIL*(IDES-1)/ADES
           X=RAD*COS(T)
           Y=RAD*SIN(T)
           XDES(IDES)=X
           YDES(IDES)=Y
         END DO
         IF(IPIC.EQ.1)THEN
          DO I=1,NDES
           CALL ADVANCE(XDES(I),YDES(I),XDES(I),YDES(I))
          END DO
         END IF
         CALL LING(XDES,YDES,NDES)
       END DO 
C------ CALCUL DES HORSES DU CONTOUR -----
       CALL THICK_PIXEL(3)
       NHORSE=12
       AHORSE=NHORSE
       DISLEN=0.12
       DISHEI=DISLEN*0.7
       DO IHORSE=1,NHORSE
        CALL HORSE_MAKE(0.,0.,2.,XDESH,YDESH,NDES)
        DO I=1,NDES
         XDES(I)=1.+1.1*DISHEI+DISHEI*YDESH(I)
         YDES(I)=-DISLEN*XDESH(I)
        END DO
C------ ROTATE -------
        PHI=2.*3.14159265*(IHORSE-1)/AHORSE
        DO I=1,NDES
         XXX=COS(PHI)*XDES(I)-SIN(PHI)*YDES(I)
         YYY=SIN(PHI)*XDES(I)+COS(PHI)*YDES(I)
         XDES(I)=XXX
         YDES(I)=YYY
        END DO 
        IF(IPIC.EQ.1)THEN
         DO I=1,NDES
          CALL ADVANCE(XDES(I),YDES(I),XDES(I),YDES(I))
         END DO
        END IF
        GREY=0.95-0.35**((IHORSE)/5.)
        CALL CLOSE_FILL(XDES,YDES,NDES,GREY,.TRUE.)
       END DO
C ----- AXES --------
       CALL THICK_PIXEL(3)
       CALL SCALE_CHAR(0.7)
       IF(IPIC.EQ.1)XINCR=0.4
       IF(IPIC.EQ.2)XINCR=0.5
       IF(IPIC.EQ.1)KX=4
       IF(IPIC.EQ.2)KX=5
       CALL AXEX(0.,0.,XMIN,XMAX,XINCR,KX)
       IDIGIT=1
       CALL LABEL_X(0.,0.,-0.99,-0.01,XINCR,IDIGIT)
       CALL LABEL_X(0.,0.,0.01,0.99,XINCR,IDIGIT)
       IF(IPIC.EQ.1)YINCR=0.4
       IF(IPIC.EQ.2)YINCR=0.5
       IF(IPIC.EQ.1)KY=4
       IF(IPIC.EQ.2)KY=5
       CALL AXEY(0.,0.,YMIN,YMAX,YINCR,KY)
       IDIGIT=1
       CALL LABEL_Y(0.,0.,-0.49,-0.01,YINCR,IDIGIT)
       CALL LABEL_Y(0.,0.,0.01,0.99,YINCR,IDIGIT)
C ------- BULLETS A ZERO  -------
       IF(IPIC.EQ.1)THEN
         CALL BUBBLE(0.,0.,0.4,1.,'circle')
       ELSE
         CALL BUBBLE(0.,0.,1.2,1.,'circle')
         CALL BUBBLE(0.,0.,0.8,1.,'circle')
         CALL BUBBLE(0.,0.,0.4,1.,'circle')
         CALL BUBBLE(1.,0.,0.4,1.,'circle')
       END IF
C ---TEXTES -----
       CALL SCALE_CHAR(1.1)
       IF(IPIC.EQ.1)CALL TEXT_RELAD(0.03,0.95,'$sm$r - plane')
       IF(IPIC.EQ.2)CALL TEXT_RELAD(0.03,0.95,'$sz$r - plane')
       CALL SCALE_CHAR(0.75)
       IF(IPIC.EQ.2)THEN
         CALL TEXT_W(0.7,-0.3,'$sz_1')
         CALL TEXT_W(0.3,0.3,'$sz_2')
         CALL TEXT_W(-0.3,-0.35,'$sz_3')
         CALL TEXT_W(0.3,-0.35,'$sz_4')
       END IF
C ----- FIN DE GRANDE BOUCLE --
      END DO
C --------- FIN -------------
      CALL END_GGG
      STOP
      END

      SUBROUTINE ADVANCE(X1,Y1,X2,Y2)
      IMPLICIT COMPLEX(Z)
      C0=-9./24.
      C1=37./24.
      C2=-59./24.
      C3=55./24.
      ZR=CMPLX(X1,Y1)
      Z=(ZR-1.)*ZR*ZR*ZR/(C0+ZR*(C1+ZR*(C2+ZR*C3)))
      X2=REAL(Z)
      Y2=AIMAG(Z)
      RETURN
      END


      SUBROUTINE NEWTON(Z,R)
C -------- ITERATIONS DE NEWTON POUR RACINES -----
      IMPLICIT COMPLEX(O-Z)
      C0=-9./24.
      C1=37./24.
      C2=-59./24.
      C3=55./24.
      Q0=-C0*Z
      Q1=-C1*Z
      Q2=-C2*Z
      Q3=-C3*Z-1.
      DO 6 ITER=1,7
      P=Q0+R*(Q1+R*(Q2+R*(Q3+R)))
      PP=Q1+R*(2.*Q2+R*(3.*Q3+4.*R))
      R=R-P/PP
  6   CONTINUE
      RETURN
      END
