C ---- MAKES A HORSE CENTERED AT XCEN, YCEN. FSCALE = DIMX AND DIMY.
C
C
       SUBROUTINE HORSE_MAKE(XCEN,YCEN,FSCALE,XDES,YDES,NDES)
        DIMENSION XDES(1),YDES(1),XDAT(1000),YDAT(1000)
        DIMENSION XDESSP(10000),YDESSP(10000)
       OPEN(12,FILE='horse_make.dat')
       REWIND 12
       NDES=0
       DO ILINE=1,11
         READ(12,*)NDAT
c         write(6,*)'  ndat=',ndat
         DO  I=1,NDAT
           READ(12,*)XDAT(I),YDAT(I)
c           write(6,*)XDAT(I),YDAT(I)
         END DO
C --------- CALCUL DU SPLINE ------
         CALL SPLINE(XDAT,NDAT,XDESSP,NDESSP)
         CALL SPLINE(YDAT,NDAT,YDESSP,NDESSP)
         IF(ILINE.EQ.1)THEN
           IDEB=1
         ELSE
           IDEB=2
         END IF
         DO I=IDEB,NDESSP
           NDES=NDES+1
           XDES(NDES)=XDESSP(I) 
           YDES(NDES)=YDESSP(I)
         END DO
       END DO
C ----- FIN LECTURE -----
       CLOSE(12)
C -------- RESCALE -------
       DO I=1,NDES
         XDES(I)=XCEN+(XDES(I)-20.)*FSCALE/40. 
         YDES(I)=YCEN+(YDES(I)-20.)*FSCALE/40.
       END DO
       RETURN
       END 
C
        SUBROUTINE SPLINE(YDAT,NDAT,YDES,NDES)
        IMPLICIT REAL*8 (A-H,O-Z)
        REAL YDES,YDAT
        PARAMETER (NDIM=1001)
        DIMENSION YDES(1),IP(NDIM),YDAT(100),DEL(NDIM)
        REAL*8 A(NDIM,NDIM),B(NDIM)
C -------- DEBUT --------
        NDES=1
        YDES(NDES)=YDAT(1)
C --------- LES DIFFERENCES --------
        DO 1 I=2,NDAT
    1   DEL(I)=YDAT(I)-YDAT(I-1)
C ------ METTRE SYSTEME LINEAIRE --------
        DO 14 I=1,NDAT
        DO 14 J=1,NDAT
  14    A(I,J)=0.D0
        DO 15 I=2,NDAT-1
  15    A(I,I)=4.D0
        DO 16 I=1,NDAT-1
        A(I,I+1)=1.D0
  16    A(I+1,I)=1.D0
        A(1,1)=2.D0
        A(NDAT,NDAT)=2.D0
        B(1)=3.D0*DEL(2)
        B(NDAT)=3.D0*DEL(NDAT)
        DO 18 I=2,NDAT-1
  18    B(I)=3.D0*(DEL(I)+DEL(I+1))
        CALL DEC (NDAT, NDIM, A, IP, IER)
        CALL SOL (NDAT, NDIM, A, B, IP)
C ----------- CALCUL DES SPLINES ------
        DO 25 IDAT=1,NDAT-1
        Y0=YDAT(IDAT)
        Y1=YDAT(IDAT+1)
        H=1.D0
        DIFF=Y1-Y0
        DO 20 I=1,6
        NDES=NDES+1
        XD=I*H/6.
 20     YDES(NDES)=Y0+(XD)*(DIFF+(XD-1.D0)*
     &    ((B(IDAT+1)-DIFF)*(XD)+(B(IDAT)-DIFF)*(XD-1.D0))/H**2)
 25     CONTINUE
        RETURN
        END

      SUBROUTINE DEC (N, NDIM, A, IP, IER)
C VERSION REAL DOUBLE PRECISION
      INTEGER N,NDIM,IP,IER,NM1,K,KP1,M,I,J
      DOUBLE PRECISION A,T
      DIMENSION A(NDIM,N), IP(N)
C-----------------------------------------------------------------------
C  MATRIX TRIANGULARIZATION BY GAUSSIAN ELIMINATION.
C  INPUT..
C     N = ORDER OF MATRIX.
C     NDIM = DECLARED DIMENSION OF ARRAY  A .
C     A = MATRIX TO BE TRIANGULARIZED.
C  OUTPUT..
C     A(I,J), I.LE.J = UPPER TRIANGULAR FACTOR, U .
C     A(I,J), I.GT.J = MULTIPLIERS = LOWER TRIANGULAR FACTOR, I - L.
C     IP(K), K.LT.N = INDEX OF K-TH PIVOT ROW.
C     IP(N) = (-1)**(NUMBER OF INTERCHANGES) OR O .
C     IER = 0 IF MATRIX A IS NONSINGULAR, OR K IF FOUND TO BE
C           SINGULAR AT STAGE K.
C  USE  SOL  TO OBTAIN SOLUTION OF LINEAR SYSTEM.
C  DETERM(A) = IP(N)*A(1,1)*A(2,2)*...*A(N,N).
C  IF IP(N)=O, A IS SINGULAR, SOL WILL DIVIDE BY ZERO.
C
C  REFERENCE..
C     C. B. MOLER, ALGORITHM 423, LINEAR EQUATION SOLVER,
C     C.A.C.M. 15 (1972), P. 274.
C-----------------------------------------------------------------------
      IER = 0
      IP(N) = 1
      IF (N .EQ. 1) GO TO 70
      NM1 = N - 1
      DO 60 K = 1,NM1
        KP1 = K + 1
        M = K
        DO 10 I = KP1,N
 10       IF (DABS(A(I,K)) .GT. DABS(A(M,K))) M = I
        IP(K) = M
        T = A(M,K)
        IF (M .EQ. K) GO TO 20
        IP(N) = -IP(N)
        A(M,K) = A(K,K)
        A(K,K) = T
 20     IF (T .EQ. 0.D0) GO TO 80
        T = 1.D0/T
        DO 30 I = KP1,N
 30       A(I,K) = -A(I,K)*T
        DO 50 J = KP1,N
          T = A(M,J)
          A(M,J) = A(K,J)
          A(K,J) = T
          IF (T .EQ. 0.D0) GO TO 50
          DO 40 I = KP1,N
 40         A(I,J) = A(I,J) + A(I,K)*T
 50       CONTINUE
 60     CONTINUE
 70   K = N
      IF (A(N,N) .EQ. 0.D0) GO TO 80
      RETURN
 80   IER = K
      IP(N) = 0
      RETURN
C----------------------- END OF SUBROUTINE DEC -------------------------
      END
C
C
      SUBROUTINE SOL (N, NDIM, A, B, IP)
C VERSION REAL DOUBLE PRECISION
      INTEGER N,NDIM,IP,NM1,K,KP1,M,I,KB,KM1
      DOUBLE PRECISION A,B,T
      DIMENSION A(NDIM,N), B(N), IP(N)
C-----------------------------------------------------------------------
C  SOLUTION OF LINEAR SYSTEM, A*X = B .
C  INPUT..
C    N = ORDER OF MATRIX.
C    NDIM = DECLARED DIMENSION OF ARRAY  A .
C    A = TRIANGULARIZED MATRIX OBTAINED FROM DEC.
C    B = RIGHT HAND SIDE VECTOR.
C    IP = PIVOT VECTOR OBTAINED FROM DEC.
C  DO NOT USE IF DEC HAS SET IER .NE. 0.
C  OUTPUT..
C    B = SOLUTION VECTOR, X .
C-----------------------------------------------------------------------
      IF (N .EQ. 1) GO TO 50
      NM1 = N - 1
      DO 20 K = 1,NM1
        KP1 = K + 1
        M = IP(K)
        T = B(M)
        B(M) = B(K)
        B(K) = T
        DO 10 I = KP1,N
 10       B(I) = B(I) + A(I,K)*T
 20     CONTINUE
      DO 40 KB = 1,NM1
        KM1 = N - KB
        K = KM1 + 1
        B(K) = B(K)/A(K,K)
        T = -B(K)
        DO 30 I = 1,KM1
 30       B(I) = B(I) + A(I,K)*T
 40     CONTINUE
 50   B(1) = B(1)/A(1,1)
      RETURN
C----------------------- END OF SUBROUTINE SOL -------------------------
      END
c
