function dudt = AmplifierIFcn(t,u,OdeCoeff)
% Differential equations:
% dy1/dt = A + y1.^2.*y2 - (B+1)*y1;
% dy2/dt = B*y1 - y1.^2.*y2;
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%    
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
% ---------------------------
Coeff = OdeCoeff;
Ub    = Coeff{1};
R0    = Coeff{3};
R     = Coeff{4};
Beta  = Coeff{5};
Ug    = Coeff{6};
Uf    = Coeff{7};
Omega = Coeff{8};
Ue    = Ug*sin(Omega*t);
f23   = Beta*(exp((u(2) - u(3))/Uf) - 1);

dudt    = zeros(5,1);
dudt(1) = - (Ue - u(1))/R0;
dudt(2) = - (Ub/R - u(2)*2/R - 0.01*f23);
dudt(3) = - (f23 - u(3)/R);
dudt(4) = - ((Ub - u(4))/R - 0.99*f23);
dudt(5) = - (- u(5)/R);

