function  yPrime = RLC_Diode(t,y,OdeCoeff)
% ---------------------------
% Circuit oscillant srie avec diode
% Le circuit est form d'une rsistance, d'une auto-induction et 
% d'une diode de type 1N4001. 
% Le modle de la diode utilis ici est celui d'une capacit et
% d'une rsistance non-linaires en parallle
%
% Voir Chatelain Dispositifs  semi-conducteur (page 62) 
% Presse Polytechnique
% 
% Equations diffrentielles:
% dU/dt = ( I -is*(exp(U/(n*UT)-1) ) / ( C0 + C1*exp(U/(nUT) )
% dI/dt = (Ug0*sin(w*t) - R*I - U)/L
% U est la diffrence de potentiel aux bornes de la diode
% I est le courant total du circuit
%----------------------------
%  Copyright (C) 2015/02, Denis Bichsel <dbichsel@infomaniak.ch>
% 
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
% ---------------------------

Diode    = OdeCoeff{1};
Gen      = OdeCoeff{2};
Circuit  = OdeCoeff{3};
R        = Circuit.R;
L        = Circuit.L;
Ug       = RLC_Gen(t,Gen);

[Ir,dIrdU,C,dCdU,d2CdU2] = RLC_Diode_IC(y(1),Diode);

yPrime(1) = y(2);
Denom     = dCdU + C;
yPrime(2) = (Ug-y(1))/L - (d2CdU2*y(1)+2*dCdU)*y(2).^2 - dIrdU*y(2) ...  
                        - R/L*Ir - R/L*dCdU*y(1)*y(2) -R*C/L*y(2);
yPrime(2) = yPrime(2)/Denom;                      
yPrime    = yPrime(:);
return

function  Ug = RLC_Gen(t,Gen)
% Calcul de la tension du gnrateur.
Ug = Gen.U0*sin(Gen.w0*t); 

