function [Ir,dIrdU,C,dCdU,d2CdU2] = RLC_Diode_IC(U,Diode)
% ---------------------------
% Relation U --> Ir    de la diode
% Relation U --> C     de la diode
% Voir:
% IEEE TRANSACTIONS ON ELECTRON DEVICES, VOL. 47, NO. 8, AUGUST 2000
% Amr Haggag and Karl Hess, Fellow, IEEE
% Analytical Theory of Semiconductor P-N Junctions and the Transition 
% Between Depletion and Quasineutral Region
%  v      : formule no 17b
%  lambda : Formule no 18 
% les valeurs numriques ont t ajuste pour la diode 1n4723
%----------------------------
%  Copyright (C) 2015/03, Denis Bichsel <dbichsel@infomaniak.ch>
% 
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
% ---------------------------

%Courant
Ut     = Diode.Ut;     % [V] (Dpend de la temprature Ut = kb*T/q)
n      = Diode.n;      % [ ]  cf. Chatelain PPUR page 62 
Is     = Diode.Is;     % [A]
Vbi    = Diode.Vbi;    % [V]
expUr  = exp(U/(n*Ut));

Ir     = Is*(expUr-1);
dIrdU  = Is/(n*Ut)*expUr;

% Capacit
alpha  = Diode.alpha;  % [1/V]
C0     = Diode.C0;     % [F]
C1     = Diode.C1;     % [F] 
expUc  = exp(alpha*(U-Vbi));

C      = C0 + C1*expUc;
dCdU   = C1*alpha*expUc;
d2CdU2 = C1*alpha*alpha*expUc;







