function yPrime = RLCDiodeTunnel(t,y,DiodeCoeff)
% Model
% A self induction L is serial with a condensator C which is in parallel
% with a tunnel diode. 
%                |---- C  ----|
%    |---- L ----|            | ----|
%    |           |---- TD ----|     |
%    |                              |
%    |---------------- Ug ----------|
% A sinusoidal generator Ug0*sin(w*t) excite the circuit.
% Model of the tunnel diode (Voltage - Current)
%  Id = Ip *(Ud/Up) .* exp(1.0 - Ud/Up) + ...
%       Iv*exp(-A2*Uv)*(exp(A2*Ud)-1)  + ...
%       Is * (exp(Ud/Ut) - 1.0);
% Ut = 25.84e-3;  Up = 0.065; Ip = 4.7e-3; Uv = 0.355; Iv = 0.45e-3;   
% Is = 50e-12; A2 = 15;
% Moodel of the circuit
% First Kirchhoff law
%   L*dI/dt + Ud = Ug
% Second Kirchhoff law
%   I = Id + Ic     
%   Ic = C*Ud'   then
%   L*(CUd'' '+ Id') + Ud = Ug
%   and in usual form:
%   Ud'' = 1/(LC)*(Ug-Ud-L*dId/dUd * Ud'
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%     
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
% ---------------------------
Ut         = DiodeCoeff{1};
Up         = DiodeCoeff{2};
Ip         = DiodeCoeff{3};
Uv         = DiodeCoeff{4};
Iv         = DiodeCoeff{5};
Is         = DiodeCoeff{6};
A2         = DiodeCoeff{7};
L          = DiodeCoeff{8};
C          = DiodeCoeff{9};
Ug0        = DiodeCoeff{10};   % Ici c'est une constante

w0   = 1/sqrt(L*C);
Ug   = Ug0*cos(w0*t);  % cos car c'est la drive de sin

Ud            = y(1);
[Id ,IdPrime] = RLCDiodeTunnel_Ir_dIr_d2Ir(Ud,DiodeCoeff);

yPrime(1)  = y(2);
yPrime(2)  = 1/(L*C)*(Ug-y(1)-L*IdPrime.*y(2));
yPrime     = yPrime(:);

 

    