function [Ir ,IrPrime,IrPrime2] = RLCDiodeTunnel_Ir_dIr_d2Ir(y,DiodeCoeff)
% Model
% A self induction L is serial with a condensator C which is in parallel
% with a tunnel diode. 
%                |---- C  ----|
%    |---- L ----|            | ----|
%    |           |---- TD ----|     |
%    |                              |
%    |---------------- Ug ----------|
% A sinusoidal generator Ug0*sin(w*t) excite the circuit.
% Model of the tunnel diode (Voltage - Current)
%  Id = Ip *(Ud/Up) .* exp(1.0 - Ud/Up) + ...
%       Iv*exp(-A2*Uv)*(exp(A2*Ud)-1)  + ...
%       Is * (exp(Ud/Ut) - 1.0);
% Ut = 25.84e-3;  Up = 0.065; Ip = 4.7e-3; Uv = 0.355; Iv = 0.45e-3;   
% Is = 50e-12; A2 = 15;
% Moodel of the circuit
% First Kirchhoff law
%   L*dI/dt + Ud = Ug
% Second Kirchhoff law
%   I = Id + Ic     
%   Ic = C*Ud'   then
%   L*(CUd'' '+ Id') + Ud = Ug
%   and in usual form:
%   Ud'' = 1/(LC)*(Ug-Ud-L*dId/dUd * Ud'
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
% ---------------------------
Ut         = DiodeCoeff{1};
Up         = DiodeCoeff{2};
Ip         = DiodeCoeff{3};
Uv         = DiodeCoeff{4};
Iv         = DiodeCoeff{5};
Is         = DiodeCoeff{6};
A2         = DiodeCoeff{7};

Ud   = y(:,1);

Ir       = Ip*(Ud/Up).*exp(1-Ud/Up)  + Iv*exp(-A2*Uv)*(exp(A2*Ud) - 1) +...
            Is*(exp(Ud/Ut)-1);
     
if nargout >= 2
  IrPrime  =  Ip/Up*exp(1-Ud/Up) - Ip/Up*(Ud/Up).*exp(1-Ud/Up) + ...
              A2*Iv*exp(A2*(Ud-Uv)) + ...
              Is/Ut*exp(Ud/Ut);
end
if nargout == 3          
  IrPrime2 = -2.0*Ip/(Up^2).*exp(1.0-Ud/Up) + ...
             (Ud*Ip)/(Up^3).*exp(1.0-Ud/Up) ...
              + A2^2*Iv*exp(A2*(Ud-Uv)) ...
              + Is/(Ut^2) * exp(Ud/Ut);
end




















