function  yPrime = RLC_Ferrite(t,y)
% ---------------------------
% Circuit oscillant srie avec bobine sur tore de ferrite
% Le circuit est form d'une rsistance, d'une auto-induction 
% non constante (bobine sur tore) et d'un condensateur.
% Le modle :
%   B ~ L0*mu*I0*tanh(I/I0) + L0*I
% La drive de tanh: (tanh)' = 1/cosh^2 ainsi:
%   L(I) = L0(1+mu/cosh(I/I0)^2)
% L0 est le coefficient de la bobine construite sans ferrite
% mu est la permabilit de la ferrite  faible courant (champs).
% Les quations diffrentielles sont:
% d(LI)/dt + RI + U = Ug
% U est la diffrence de potentiel aux bornes du condensateur
% I est le courant total du circuit
%----------------------------
%  Copyright (C) 2015/02, Denis Bichsel <dbichsel@infomaniak.ch>
% 
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
% ---------------------------

global L0 mu I0 R C U0 w0

I   = C*y(2);
L   = L0 + L0*mu ./(cosh(I/I0)).^2; 
Ug  = U0*sin(w0*t);

yPrime(1) = y(2);
yPrime(2) = (Ug-y(1)-R*C*y(2))/(L*C);                    
yPrime    = yPrime(:);
