function  Jac = RLC_FerriteJac(t,y)
% ---------------------------
% Circuit oscillant srie avec bobine sur tore de ferrite
% Le circuit est form d'une rsistance, d'une auto-induction 
% non constante (bobine sur tore) et d'un condensateur.
% 
% Equations diffrentielles:
% d(LI)/dt + R*I + U = Ug0*sin(w*t) 
% U est la diffrence de potentiel aux bornes du condensateur
% I est le courant total du circuit
%----------------------------
%  Copyright (C) 2015/02, Denis Bichsel <dbichsel@infomaniak.ch>
% 
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
% ---------------------------

global L0 mu I0 R C U0 w0

I   = C*y(2);
L   = L0 + L0*mu ./(cosh(I/I0)).^2; 

Jac      = zeros(2);
Jac(1,2) = 1;
Jac(2,1) = -1/(L*C);
Jac(2,2) = -R/L;

