function  [Phi,L] = RLC_Ferrite_Phi_L(I)
% ---------------------------
% Coefficient d'auto-induction en fonction du courant et
% drive de ce coefficient par rapport au courant.
% Le modle :
%   B ~ L0*mu*I0*tanh(I/I0) + L0*I
% La drive de tanh: (tanh)' = 1/cosh^2 ainsi:
%   L(I) = L0(1+mu/cosh(I/I0)^2)
% L0 est le coefficient de la bobine construite sans ferrite
% mu est la permabilit de la ferrite  faible courant (champs).
% Les quations diffrentielles sont:
% d(LI)/dt + RI + U = Ug
% U est la diffrence de potentiel aux bornes du condensateur
% I est le courant total du circuit

%----------------------------
%  Copyright (C) 2015/03, Denis Bichsel <dbichsel@infomaniak.ch>
% 
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
% ---------------------------

global L0 mu I0

Phi =  L0*I + L0*mu*I0*tanh(I/I0);
L   =  L0 + L0*mu ./(cosh(I/I0)).^2; 
