function Jac = Jacobian(t,M)

  global Cm GNa GK GL VT VK VNa    ...
         am1 am2 am3 am4 am5 ...
         bm1 bm2 bm3 bm4 bm5 ...
         an1 an2 an3 an4 an5 ...
         bn1 bn2 bn3         ...
         ah1 ah2 ah3         ...
         bh1 bh2 bh3 bh4        
   
  Vm = M(1);
  m  = M(2);
  n  = M(3);
  h  = M(4);
  
  amexp   = exp(-(Vm-VT+am3)/am4);
  bmexp   = exp( (Vm-VT+bm3)/bm4);    
  alpham  =  am1*(Vm-VT+am2)/(amexp+am5);
  betam   =  bm1*(Vm-VT+bm2)/(bmexp+bm5);
  
  anexp   = exp(-(Vm-VT+an3)/an4);
  bnexp   = exp(-(Vm-VT+bn2)/bn3);
  alphan  =  an1*(Vm-VT+an2)./(anexp+an5);
  betan   =  bn1*bnexp;
  
  ahexp   = exp(-(Vm-VT+ah2)/ah3);
  bhexp   = exp(-(Vm-VT+bh3)/bh4);
  alphah  =  ah1*ahexp;
  betah   =  bh1/(bh2+bhexp);   

%   dVm = (1/Cm)* ( Im - GNa * m^3 * h*(Vm-VNa) - ...
%                   GK  * n^4 * (Vm-VK)    - ...
%                   GL*(Vm - VL));
  Jac(1,1) = ( -GNa*m^3*h - GK*n^4 - GL)/Cm ;
  Jac(1,2) = ( -3*GNa*h*m^2*(Vm-VNa) )/Cm;
  Jac(1,3) = ( -4*GK*n^3*(Vm-VK) )/Cm;
  Jac(1,4) = ( -GNa*m^3*(Vm-VNa) )/Cm;
  
%   dm  = alpham*(1-m)-betam*m;
%   alpham  =  am1*(Vm-VT+am2)/(exp(-(Vm-VT+am3)/am4)+am5);
%   betam   =  bm1*(Vm-VT+bm2)/(exp((Vm-VT+bm3)/bm4)+bm5);
  Jac(2,1) = (  am1/(amexp+am5)  ...
               -am1/am4*(Vm-VT+am2)*amexp/((amexp+am5)^2) ) * (1-m) ...
            -(  bm1/(bmexp +bm5)  ...
               +bm1/bm4*(Vm-VT+bm2)*bmexp/((bmexp+bm5)^2) ) * m;          
  Jac(2,2) = -alpham - betam;
  Jac(2,3) = 0;
  Jac(2,4) = 0;

%   dn  = alphan*(1-n) - betan*n;
%   alphan  =  an1*(Vm-VT+an2)/(exp(-(Vm-VT+an3)/an4)+an5);
%   betan   =  bn1*exp(-(Vm-VT+bn2)/bn3);  
  Jac(3,1) = (  an1/(anexp+an5) + ...
               -an1/an4*(Vm-VT+an2)*anexp/((anexp+an5)^2) ) * (1-n) ...
            -(  bn1/bn3*bnexp * n );  
  Jac(3,2) = 0;
  Jac(3,3) = -alphan - betan;
  Jac(3,4) = 0;

%   dh  = alphah*(1-h) - betah*h;
%   alphah  =  ah1*exp(-(Vm-VT+ah2)/ah3);
%   betah   =  bh1/((bh2+exp(-(Vm-VT+bh3)/bh4));   
  Jac(4,1) = -ah1/ah3*ahexp  - bh1/bh4 * ahexp/((bh2+ahexp)^2);
  Jac(4,2) = 0;
  Jac(4,3) = 0;
  Jac(4,4) = -alphah - betah;


