clear all;  
close all; 
clc;

addpath addpath D:\Octave\RDPSolver % D:\Matlab\RDPSolver

global Cm GNa GK GL VNa VK VL VT ...
       am1 am2 am3 am4 am5 bm1 bm2 bm3 bm4 bm5 ...
       an1 an2 an3 an4 an5 bn1 bn2 bn3         ...
       ah1 ah2 ah3 bh1 bh2 bh3 bh4             ...
       tsaut
% Voir: const.f de M.S.      
Cm   = 0.29;   GNa  = 50000.0; GK   = 4200.0; GL   = 100.0;
VNa  = 50.0;   VK   = -90.0;   VL   = -75.0;  VT   = -58.0;
am1  = -0.32;  am2  = -13.0;   am3  = -13.0;  am4  = 4.0;    am5  = -1.0;
bm1  = 0.28;   bm2  = -40.0;   bm3  = -40.0;  bm4  = 5.0;    bm5  = -1.0;
an1  = -0.032; an2  = -15.0;   an3  = -15.0;  an4  = 5.0;    an5  = -1.0;
bn1  = 0.5;    bn2  = -10.0;   bn3  = 40.0;
ah1  = 0.128;  ah2  = -17.0;   ah3  = 18.0;
bh1  = 4.0;    bh2  =  1.0;    bh3  = -40.0;  bh4  = 5.0;

% Lecture des fichiers time, stimulus (inutile pour la suite).
FileT       = 'timevec_test.txt';
timevec     = load(FileT)';  % timevec contient des valeurs de 0  2.9940
% FileS       = 'stimulus_test.txt';
% stimulusvec = load(FileS)';
% stimulus vaut 2675 pour 0 < t <=  tsaut = 0.078 et 0 ensuite

% Variation de tsaut:
% Si tsaut <= 0.080795, le neurone ne transmet pas le signal, Vm commence
% par crotre pour t <= tsaut et ensuite Vm tend rapidement vers -75.
% Pour tsaut > 0.080796, le neurone transmet l'information, la valeur 
% maximale de Vm atteint 50 environ.
% La solution prsente un maximum local en tsaut. Ce maximum ne disparat
% pas lorsque tsaut augmente jusqu' 0.15. 
% Si la dfinition des graphiques est insuffisante, on ne voit plus.
% Afin d'augmenter la qualit du graphique je redfinis timevec: 

timevec = linspace(0,0.3,3001);

tsaut = 0.082;%0.080796;

tol          = 1e-10;  
RelTolDef    = tol;
AbsTolDef    = tol;
NbrStgDef    = 5;
MinNbrStgDef = 3;
MaxNbrStgDef = 7;
options = [];
options = rdpset(options,'RelTol',RelTolDef);
options = rdpset(options,'AbsTol',AbsTolDef);
options = rdpset(options,'NbrStg',NbrStgDef);
options = rdpset(options,'MinNbrStg',MinNbrStgDef);
options = rdpset(options,'MaxNbrStg',MaxNbrStgDef);

% Conditions initiales
Vm0 = -65;
[alpham0,betam0,alphan0,betan0,alphah0,betah0] = alphabeta(Vm0);
M0 = [Vm0;alpham0./(alpham0+betam0);alphan0./(alphan0+betan0);alphah0./(alphah0+betah0)];

tic
[tout,M] = radau('func2MatOct',timevec,M0,options);
radau_t = toc
plot(tout,M(:,1))
grid on
title(['tsaut = ', num2str(tsaut),'  avec jacobien numrique'  ])

JacDef  = @Jacobian;
options = rdpset(options,'JacFcn',JacDef);
Index = 1;
[tout1,M1] = radau('func2MatOct',timevec,M0,options,Index);
radau_t = toc
figure
plot(tout1,M1(:,1),'r')
grid on
title(['tsaut = ', num2str(tsaut),'  avec jacobien analytique' ])

figure
plot(tout,M-M1) 
grid on
title('Diffrence des solutions avec jacobien numrique et analytique')

% Le code suivant permet de comparer l'efficacit de radau et ode23s
%
% op = odeset('RelTol',tol);
% op = odeset(op,'AbsTol',tol);
% tic
% % for k = 1 : 5
% [tout1,M1] = ode23s('func2MatOct',[timevec],M0,op);
% % end
% ode23s_t = toc
% plot(tout1,M1(:,1),'r')
% grid on
% title('radau en bleu  ode23s en rouge')
% [Max, Ind] = max (abs(M(:,1) - M1(:,1)));
% DiffMax_radau_ode23s = Max
% M_de_DiffMax = M(Ind,1)
% DiffMax_M = Max/M(Ind,1)

% Les solutions obtenues par "radau" et par "ode23s", sont graphiquement
% presque identiques ds que la tolrance est <= 1e-6, par contre le temps
% de calcul n'est pas le mme, voir ci-dessous.

% Temps de calcul pour radau en fonction de la tolrance (tsaut = 0.082)
%  Tol:     1e-4    1e-5    1e-6    1e-7    1e-8    1e-10   1e-12
%  Temps:   0.2122  0.2605  0.3334  0.4286  0.4948  0.8258  0.9957

% Temps de calcul pour ode23s en fonction de la tolrance (tsaut = 0.082)
% Tol:      1e-4    1e-5    1e-6    1e-7   1e-8    etc
% Temps:    0.4237  1.1338  3.0889  7.7954 17.605  etc

