function dM = func2MatOct(t,M)
    
  global Cm GNa GK GL VNa VK VL tsaut
  
  % stimulus vaut 2675 pour 0 < t <=  tsaut = 0.078 et 0 ensuite

  % Si tsaut <= 0.080795, le neurone ne transmet pas le signal, Vm commence
  % par crotre pour t <= tsaut et ensuite Vm tend rapidement vers -75.
  % Pour tsaut > 0.080796, le neurone transmet l'information, la valeur 
  % maximale de Vm atteint 50 environ.
  % La solution prsente un maximum local en tsaut. Ce maximum ne disparat
  % pas lorsque tsaut augmente jusqu' 0.15. 
  % Si la dfinition des graphiques est insuffisante, on ne voit plus.
  
  Im = 0;
  if t <= tsaut    % 0.078  % lu dans le fichier "stimulus"
    Im = 2675;
  end
  
  Vm = M(1);
  m  = M(2);
  n  = M(3);
  h  = M(4);
  
  [alpham,betam,alphan,betan,alphah,betah] = alphabeta(Vm);
  dVm = (1/Cm)* ( Im - GNa * m^3 * h*(Vm-VNa) - ...
                       GK  * n^4 * (Vm-VK)    - ...
                       GL*(Vm - VL));        
  dm  = alpham*(1-m) - betam*m;
  dn  = alphan*(1-n) - betan*n;
  dh  = alphah*(1-h) - betah*h;  
  dM  = [dVm;dm;dn;dh];
end 