function yp = Ex2Fcn(t,y)
%  This is an artificial problem with two sets of consistent initial 
%  conditions.  The equations and the initial value for the differential
%  variable are
%
%        y' = - y - z                        y(0) = 1
%        0  = exp(-2t) + (y - 1 - z)*z
%    
%  At t = 0 there are two solutions to the algebraic equation
%
%        0  =    1     + (1 - 1 - z)*z
%
%  The value z0 = +1 leads to y(t) = exp(-2t) = z(t).  The value
%  z0 = -1 leads to a rather different solution.  Guesses of +2
%  and -2 are used to test the computation of consistent initial
%  conditions.
% Copyright 2004, The MathWorks, Inc.
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%    
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
%  Copyright (C) 2015/02, Denis Bichsel <dbichsel@infomaniak.ch>
%  Copyright (C) 2015/02, Denis Bichsel <dbichsel@infomaniak.ch>
% ---------------------------
yp = [ (- y(1) - y(2))
       (exp(-2*t) + (y(1) - 1 - y(2))*y(2)) ];