% Driver for Ex2 of Mathworks
%  This is an artificial problem with two sets of consistent initial 
%  conditions.  The equations and the initial value for the differential
%  variable are
%
%        y' = - y - z                        y(0) = 1
%        0  = exp(-2t) + (y - 1 - z)*z
%    
%  At t = 0 there are two solutions to the algebraic equation
%
%        0  =    1     + (1 - 1 - z)*z
%
%  The value z0 = +1 leads to y(t) = exp(-2t) = z(t).  The value
%  z0 = -1 leads to a rather different solution.  Guesses of +2
%  and -2 are used to test the computation of consistent initial
%  conditions.
% Copyright 2004, The MathWorks, Inc.
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%    
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
%  Copyright (C) 2015/02, Denis Bichsel <dbichsel@infomaniak.ch>
%  Copyright (C) 2015/02, Denis Bichsel <dbichsel@infomaniak.ch>
% ---------------------------
clc
close all
clear all

addpath D:\RDPSolver

ProblemName = 'Ex2';

% Function and jacobian
FcnDef  = @Ex2Fcn;
MassDef = @Ex2Mass;

Ti    = 0;
Tf    = 1;
tspan = [Ti Tf];

tol        = 1e-3;
RelTolDef  = tol;
AbsTolDef  = tol;

NbrStgDef    = 3; 
MinNbrStgDef = 3;
MaxNbrStgDef = 7;

options = [];
options = rdpset(options,'NbrStg',NbrStgDef);
options = rdpset(options,'MinNbrStg',MinNbrStgDef);
options = rdpset(options,'MaxNbrStg',MaxNbrStgDef);
options = rdpset(options,'RelTol',RelTolDef);
options = rdpset(options,'AbsTol',AbsTolDef);
options = rdpset(options,'MassFcn',MassDef);

% First set of initial conditions
y0 = [1; 1];

tic
[t1,y1] = radau(FcnDef,tspan,y0,options); 
T_radau = toc

% Second set of initial conditions
y0 = [1; -1];
tic
[t2,y2] = radau(FcnDef,tspan,y0,options); 
T_radau = toc

figure(1)
plot(t1,y1(:,1),t2,y2(:,1))
grid on
legend('set 1 ','set 2 ')
title('Problem with Two Sets of Consistent ICs.') 
xlabel('Differential Variable')

figure(2)
plot(t1,y1(:,2),t2,y2(:,2))
grid on
legend('set 1 ','set 2 ')
title('Problem with Two Sets of Consistent ICs.') 
xlabel('Algebraic Variable')

