function ex2
%  This is an artificial problem with two sets of consistent initial 
%  conditions.  The equations and the initial value for the differential
%  variable are
%
%        y' = - y - z                        y(0) = 1
%        0  = exp(-2t) + (y - 1 - z)*z
%    
%  At t = 0 there are two solutions to the algebraic equation
%
%        0  =    1     + (1 - 1 - z)*z
%
%  The value z0 = +1 leads to y(t) = exp(-2t) = z(t).  The value
%  z0 = -1 leads to a rather different solution.  Guesses of +2
%  and -2 are used to test the computation of consistent initial
%  conditions.

% Copyright 2004, The MathWorks, Inc.

tspan = [0 1];
M = diag([1 0]);
options = odeset('Mass',M);

%solving with first set of initial conditions
y0 = [1; +2];
tic
[t1,y1] = ode15s(@ex2ode,tspan,y0,options);
T_ode15s = toc
% solving with second set of initial conditions
y0 = [1; -2];
tic
[t2,y2] = ode15s(@ex2ode,tspan,y0,options);
T_ode15s = toc
figure(1)
plot(t1,y1(:,1),t2,y2(:,1))
legend('set 1 ','set 2 ')
title('Problem with Two Sets of Consistent ICs.') 
xlabel('Differential Variable')

figure(2)
plot(t1,y1(:,2),t2,y2(:,2))
legend('set 1 ','set 2 ')
title('Problem with Two Sets of Consistent ICs.') 
xlabel('Algebraic Variable')

%-------------------------------------------------------------------------

function  yp = ex2ode(t,y)

yp = [ (- y(1) - y(2))
       (exp(-2*t) + (y(1) - 1 - y(2))*y(2)) ];
