% Driver for Ex3 of Mathworks
%  This is the pendulum problem posed as an index 1 problem.  Formulated as 
%  an index 2 problem, it is used as an example in E. Hairer, Ch. Lubich,
%  and M. Roche, The Numerical Solution of Differential-Algebraic Systems 
%  by Runge-Kutta Methods, Lecture Notes in Math. #1409, Springer, Berlin,
%  1989. The values of the parameters here are taken from their FORTRAN 
%  program.  The problem is solved in forms of index 3, 2, and 1 in 
%  K. Brenan, S. Campbell, and L. Petzold, Numerical Solution of Initial-
%  Value Problems in Differential-Algebraic Equations, SIAM, Philadelphia,
%  1996.
%
%  (p,q) are the Cartesian coordinates of the bob of the pendulum.  (u,v)
%  are the velocities.  L is the length of the pendulum and lambda is the
%  tension in the rod.  g is the acceleration due to gravity.
%
%        p' = u                                  
%        q' = v                                  
%       mu' = -p*lambda                          
%       mv' = -q*lambda - g                      
%        0  = m*(u^2 + v^2) - g*q - l^2 * lambda   algebraic equation
%
%  Here  y(1) = p, y(2) = q, y(3) = u, y(4) = v, y(5) = lambda
%
%  The parameters are    m = 1, l = 1, g = 1    and    0 <= t <= 10.
%
%  Hairer & Wanner's RADAU5 requires consistent initial conditions,
%  which are obvious in this case.
%
% Copyright 2004, The MathWorks, Inc.
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%    
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
% ---------------------------

clc
close all
clear all

addpath D:\RDPSolver

ProblemName = 'Ex3';

% Function and jacobian
FcnDef  = @Ex3Fcn;
JacDef  = @Ex3Jac;
MassDef = @Ex3Mass;


% Initial conditions
y0    = zeros(5,1);
y0(1) = 1;

Ti    = 0;
Tf    = 10;
tspan = [Ti Tf];

NbrStgDef    = 3; 
MinNbrStgDef = 3;
MaxNbrStgDef = 7;

options = [];

options = rdpset(options,'NbrStg',NbrStgDef);
options = rdpset(options,'MinNbrStg',MinNbrStgDef);
options = rdpset(options,'MaxNbrStg',MaxNbrStgDef);
options = rdpset(options,'MassFcn',MassDef);
options = rdpset(options,'JacFcn',JacDef);

tic
[t,y] = radau(FcnDef,tspan,y0,options); 
T_radau = toc

figure(1)
plot(t,y(:,1:4))
title('Pendulum Problem as Index 1 DAE')
grid on


