function Mass = Ex7Mass(MassCoeff)
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%    
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
%  Copyright (C) 2015/02, Denis Bichsel <dbichsel@infomaniak.ch>
% 
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
% ---------------------------
c         = MassCoeff{2};
Mass      = sparse(5,5);
Mass(1,1) = -c(1);
Mass(1,2) =  c(1);
Mass(2,1) =  c(1);
Mass(2,2) = -c(1);
Mass(3,3) = -c(2);
Mass(4,4) = -c(3);
Mass(4,5) =  c(3);
Mass(5,4) =  c(3);
Mass(5,5) = -c(3);