function dudt = Ex8Fcn(t,u,OdeCoeff)
%  This is the two transistor amplifier problem of E. Hairer, C. Lubich, 
%  and M. Roche, The Numerical Solution of Differential-Algebraic Systems
%  by Runge-Kutta Methods, Lecture Notes in Math. #1409, Springer, Berlin,
%  1989.  It is solved in the form M*u' = f(t,u) with a mass matrix that is
%  not diagonal.  The mass matrix is treated as a sparse matrix to test the
%  capability.  Fig. 9.4 of HLR shows the solution on [0 0.2], but here it
%  is computed on [0 0.05] because the computation is less expensive and the
%  nature of the solution is clearly visible on the shorter interval.
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%    
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
%  Copyright (C) 2015/02, Denis Bichsel <dbichsel@infomaniak.ch>
% ---------------------------
Ub       = OdeCoeff{1};
R0       = OdeCoeff{3};
R        = OdeCoeff{4};
Alpha    = OdeCoeff{5};
Beta     = OdeCoeff{6};
Ug       = OdeCoeff{7};
Uf       = OdeCoeff{8};
Omega    = OdeCoeff{9};

Ue  = Ug*sin(Omega*t);
f23 = Beta*(exp((u(2) - u(3))/Uf) - 1);
f56 = Beta*(exp((u(5) - u(6))/Uf) - 1);

dudt    = zeros(8,1);
dudt(1) = - ((Ue - u(1))/R0);
dudt(2) = - ((Ub - u(2))/R - u(2)/R + (Alpha - 1)*f23);
dudt(3) = - (f23 - u(3)/R);
dudt(4) = - ((Ub - u(4))/R - Alpha*f23);
dudt(5) = - ((Ub - u(5))/R - u(5)/R + (Alpha - 1)*f56);
dudt(6) = - (f56 - u(6)/R);
dudt(7) = - ((Ub - u(7))/R - Alpha*f56);
dudt(8) = - (- u(8)/R);

