function Mass = Ex8Mass(MassCoeff)
%  This is the two transistor amplifier problem of E. Hairer, C. Lubich, 
%  and M. Roche, The Numerical Solution of Differential-Algebraic Systems
%  by Runge-Kutta Methods, Lecture Notes in Math. #1409, Springer, Berlin,
%  1989.  It is solved in the form M*u' = f(t,u) with a mass matrix that is
%  not diagonal.  The mass matrix is treated as a sparse matrix to test the
%  capability.  Fig. 9.4 of HLR shows the solution on [0 0.2], but here it
%  is computed on [0 0.05] because the computation is less expensive and the
%  nature of the solution is clearly visible on the shorter interval.
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%    
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
%  Copyright (C) 2015/02, Denis Bichsel <dbichsel@infomaniak.ch>
% ---------------------------
c         = MassCoeff{2};  
c         = c*[1:5];
Mass      = sparse(8,8);
Mass(1,1) = -c(1);
Mass(1,2) =  c(1);
Mass(2,1) =  c(1);
Mass(2,2) = -c(1);
Mass(3,3) = -c(2);
Mass(4,4) = -c(3);
Mass(4,5) =  c(3);
Mass(5,4) =  c(3);
Mass(5,5) = -c(3);
Mass(6,6) = -c(4);
Mass(7,7) = -c(5);
Mass(7,8) =  c(5);
Mass(8,7) =  c(5);
Mass(8,8) = -c(5);
