function yp = Ex9Fcn(t,y)
%  This is the DAS 1 test problem of I. Cameron, Solution of differential-
%  algebraic systems using diagonally implicit Runge-Kutta methods, IMA
%  J. Num. Anal., 3 (1983) 273-289.  He attributes it to C.W. Gear, 
%  Simultaneous numerical solution of differential-algebraic equations, 
%  IEEE Trans. Circuit Theory CT-18 (1971) 89-95.  The problem is to be 
%  solved on [0 1000].  Because the solution components tend quickly to 
%  limit values, they are plotted on a much shorter interval.
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%    
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
% ---------------------------
 B = [ 447.5 -452.5  -47.5  -52.5
       -452.5  447.5   52.5   47.5
        -47.5   52.5  447.5  452.5
        -52.5   47.5  452.5  447.5];

  B = B + 0.00025*[ 1  1  1  -1
                    1  1  1  -1
                    1  1  1  -1
                   -1 -1 -1   1];      
     
  yp = zeros(8,1);
  r = (y(1) + y(2) + y(3) + y(4))/2;
  s = 0;
  for i = 1:4
    s = s + (r - y(i))^2;
  end  
  s = s/2;
  for i = 1:4
    yp(i) = s - (r - y(i))^2;
  end
  yp(1:4) = yp(1:4) - B*y(1:4);
  yp(5) = y(5) - y(1)*y(6);
  yp(6) = 2*y(6) + y(6)^3 - y(1) + y(7) - 1 - exp(-t);
  yp(7) = y(7) - y(8) + y(1)*y(6);
  yp(8) = y(7) + y(8) + 5*y(1)*y(2);
  