% Driver for Ex9 problem, Gear test problem.
%  This is the DAS 1 test problem of I. Cameron, Solution of differential-
%  algebraic systems using diagonally implicit Runge-Kutta methods, IMA
%  J. Num. Anal., 3 (1983) 273-289.  He attributes it to C.W. Gear, 
%  Simultaneous numerical solution of differential-algebraic equations, 
%  IEEE Trans. Circuit Theory CT-18 (1971) 89-95.  The problem is to be 
%  solved on [0 1000].  Because the solution components tend quickly to 
%  limit values, they are plotted on a much shorter interval.
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%    
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
% ---------------------------

clc
clear all
close all
 
addpath D:\RDPSolver

ProblemName = 'Ex9';

% Function and jacobian
FcnDef  = @Ex9Fcn;
MassDef = @Ex9Mass;

% Initial conditions (they must be consistent and they are)
y0    = - ones(8,1);
y0(6) =  1;
y0(7) = -2;
y0(8) = -3;

Ti    = 0;
Tf    = 1000;
tspan = [Ti Tf];

RelTolDef  = 1e-3;
AbsTolDef  = 1e-6;

InfoStatDef    = true;
InfoDynDef     = true;

NbrStgDef    = 3; 
MinNbrStgDef = 3;
MaxNbrStgDef = 7;

options = [];
options = rdpset(options,'RelTol',RelTolDef);
options = rdpset(options,'AbsTol',AbsTolDef);
options = rdpset(options,'NbrStg',NbrStgDef);
options = rdpset(options,'MinNbrStg',MinNbrStgDef);
options = rdpset(options,'MaxNbrStg',MaxNbrStgDef);
options = rdpset(options,'MassFcn',MassDef);

tic
[t,y,Stats] = radau(FcnDef,tspan,y0,options);    
T_radau = toc

InfoStat = Stats.Stat;
InfoDyn  = Stats.Dyn;

i = find(t <= 6);
tlast = t(max(i));
figure(1)
plot(t(i),y(i,:))
axis([0 tlast -80 10])
title('Gear''s Stiff Test Problem')
grid on

if InfoDynDef
  figure
  tout = t;
  yout = y;
  subplot(4,1,1)
  plot(tout,real(yout(:,1)))   
  hold on
  plot(tout,real(yout(:,1)),'.b')
  grid on
  plot(tout,real(yout(:,8)))
  plot(tout,real(yout(:,8)),'.r')
  title('Gear''s Stiff Test Problem')
    
  subplot(4,1,2)
  semilogy(InfoDyn.haccept_t,InfoDyn.haccept);
  hold on
  grid on
  semilogy(InfoDyn.haccept_t,InfoDyn.haccept,'.k');
  plot(InfoDyn.hreject_t,InfoDyn.hreject,'xr')
  xlim([Ti Tf])
  title('Length of steps in function of time')
    
  subplot(4,1,3)
  plot(InfoDyn.Newt_t,InfoDyn.NewtNbr)
  grid on
  xlim([Ti Tf])
  title('Newton iteration number in function of time')
    
  subplot(4,1,4)
  plot(InfoDyn.Newt_Step,InfoDyn.NewtNbr)
  hold on
  plot(InfoDyn.Jac_Step,0.5,'.b');
  title('Newton iteration number in function of steps and jacobian')
  
  figure
  subplot(2,1,1)
  plot(InfoDyn.NbrStg_t,InfoDyn.NbrStg,'or')
  grid on
  title('Number of Stages versus Time')
  subplot(2,1,2)
  plot(InfoDyn.NbrStg_Step,InfoDyn.NbrStg,'ob')
  grid on
  title('Number of Stages versus Steps Number')
  Nbr1 = length(find(InfoDyn.NbrStg == 1));
  Nbr3 = length(find(InfoDyn.NbrStg == 3));
  Nbr5 = length(find(InfoDyn.NbrStg == 5));
	Nbr7 = length(find(InfoDyn.NbrStg == 7));
  NbrStg_1_3_5_7 = [Nbr1, Nbr3, Nbr5, Nbr7]
end
if InfoStatDef  
  InfoStat = InfoStat
end




