function Mass = Ex12Mass(MassCoeff)
%  This is Problem 1 from P.M. Dew and J.E. Walsh, A set of library 
%  routines for solving parabolic equations in one space variable, ACM
%  Trans. Math. Software, 7(1981) 295-314.  They use it to illustrate
%  the capability of their method of lines code for solving problems
%  of both elliptic and parabolic type.  In this approach to solving
%  PDEs, the parabolic equations give rise to ODEs and the elliptic 
%  equations to algebraic equations.  The two equations are
%
%           0 = D^2(u1)/Dx^2 - exp(-2*u2)
%    D(u2)/Dt = D^2(u2)/Dx^2 + exp(-2*u2) - exp(-u1) 
%
%  The problem is set on 0 <= x <= 1 and t >= 0.  The initial values are  
%  u2(x,0) = log(x+p)  for a parameter p > 1.  Here we take p = 10.
%
%  The boundary conditions at x = 0 are D(u1)/Dx = exp(-u1) and 
%  u2 = log(p+t).  The boundary conditions at x = 1 are u1 = log(1+p+t)
%  and D(u2)/Dx = exp(-u1).
%
%  The analytical solution is u1 = u2 = log(x+p+t).
%  
%  This example is interesting because it is representative of a class
%  of DAEs, it involves a "large" number of algebraic equations, and the
%  obvious initial conditions are inconsistent. The problem is solved
%  quickly, but it is sufficiently large and the Jacobian is sufficiently
%  sparse that it is a good idea to inform the code about the structure
%  of the Jacobian.  This is done to illustrate how to proceed.
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%    
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
% ---------------------------
N     = MassCoeff(2);
Mass  = diag([zeros(N+1,1); ones(N-1,1)]);
