function yp = Ex14Fcn(t,y,Index)
%  The pendulum problem arises most naturally as an index 3 problem
%  with an algebraic equation that says the length L of the pendulum
%  is constant.  It can be reduced by differentiation to an index 2
%  problem and by another to an index 1 problem.  
%  In this example, the pendulum problem is solved as an index 1, index 2
%  and index 3 DAE.
%
%  The differential equations are
%        y(1)' =  y(3)            or   p' = u                            
%        y(2)' =  y(4)            or   q' = v                                 
%      m*y(3)' = -y(1)*y(5)     or  mu' = -p*lambda                       
%      m*y(4)' = -y(2)*y(5)     or  mv' = -q*lambda - g   
%
%  The algebraic equation for index 3 is                   
%        0 = y(1)^2 + y(2)^2      or  0  = p^2 + q^2 - L^2 
%
%  The algebraic equation for index 2 is
%        0 = y(1)*y(3) + y(2)*y(4) or  0  = p*u + q*v   
%
%  The algebraic equation for index 1 is
%        0  = m*(y(3)^2 + y(4)^2) -g*y(2) - y(5)*L^2  or
%        0  = m*(u^2 + v^2) - g*q - lambda*L^2
%
%   where  y(1) = p, 
%          y(2) = q, 
%          y(3) = u, 
%          y(4) = v, 
%          y(5) = lambda
%
%   Parameters  m = 1, L = 1, g = 1.
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%    
% See also  http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
% ---------------------------
g     = 1;
if Index == 1
  yp    = zeros(5,1);
  yp(1) =  y(3);
  yp(2) =  y(4);
  yp(3) = -y(1)*y(5);
  yp(4) = -y(2)*y(5) - 1;
  yp(5) =  y(3)^2 + y(4)^2 - y(2) - y(5);
elseif Index == 2
  yp    = zeros(5,1);
  yp(1) =  y(3);
  yp(2) =  y(4);
  yp(3) = -y(1)*y(5);
  yp(4) = -y(2)*y(5) - g;
  yp(5) =  y(1)*y(3) + y(2)*y(4);  
elseif Index == 3
  yp    = zeros(5,1);
  yp(1) =  y(3);
  yp(2) =  y(4);
  yp(3) = -y(1)*y(5);
  yp(4) = -y(2)*y(5) - g;
  yp(5) =  y(1)^2 + y(2)^2 - 1;
end




