function dfdy = DAE1Jac(t,y)
% Differential equations:
% epsilon*y'' + 2*y' + y = 0
% or
%         y' = z
% epsilon*z' = -y - 2*z
% The epsilon value is given in the mass function
%
% If epsilon == 0, the initial conditions [y0,z0] must be [y0,-0.5y0] 
% and the solution is : y = y0*exp(-0.5*t)
% if epsilon ~= 0 the solution is :
%                    y = y1*exp(L1*t) + y2*exp(L2*t)
% with 
% L1 = (-1+sqrt(1-epsilon))/(epsilon)
% L2 = (-1-sqrt(1-epsilon))/(epsilon)
% Let the initial conditions [y0,-0.5y0] the solution is
% y(t) = y0 * ((L2-0.5)/(L2-L1)exp(L1*t) + (L1-0.5)/(L1-L2) )
% ---------------------------
% See   
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%     
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
%  Copyright (C) 2015/02, Denis Bichsel <dbichsel@infomaniak.ch>
% 
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
% ---------------------------
dfdy = [ 0   1
        -1  -2 ];

