function [Ir ,IrPrime, IrPrime2] = DiodeTunnel_Ir_dIr_d2Ir(y,DiodeCoeff)
% Model of the circuit
% Tunnel diode resistance self and condensator in serie with a
% constant voltage source.
% Tunnel diode model:
% In the tunnel diode, the voltage-current looks like:
%   Id = Ip *(Ud/Up) .* exp(1.0 - Ud/Up) + ...
%        Iv*exp(-A2*Uv)*(exp(A2*Ud)-1)  + ...
%        Is * (exp(Ud/Ut) - 1.0);
%   Id : current in the diode
%   Ud : diode voltage
%   Ip : peak current
%   Iv : valley current
%   Up : peak voltage
%   Uv : valley voltage
%   Equations (Kirchhoff)
%   L*dI/dt + Ud + Uc = Ug
%   I = C*Uc' 
%   L*CUd'' + R(C*Ud')*C*Ud' + Ud = Ug
%   or
%   Ud'' = 1/(LC)*(Ug-Ud-R(C*Ud')*C*Ud' )
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
% ---------------------------
Ut         = DiodeCoeff{1};
Up         = DiodeCoeff{2};
Ip         = DiodeCoeff{3};
Uv         = DiodeCoeff{4};
Iv         = DiodeCoeff{5};
Is         = DiodeCoeff{6};
A2         = DiodeCoeff{7};

Ud         = y(:,1);

IrPrime    = [];
IrPrime2   = [];

Ir         = Ip*(Ud/Up).*exp(1-Ud/Up)  + Iv*exp(-A2*Uv)*(exp(A2*Ud) - 1) +...
             Is*(exp(Ud/Ut)-1);
     
if nargout >= 2
  IrPrime  =  Ip/Up*exp(1-Ud/Up) - Ip/Up*(Ud/Up).*exp(1-Ud/Up) + ...
              A2*Iv*exp(A2*(Ud-Uv)) + ...
              Is/Ut*exp(Ud/Ut);
end
if nargout == 3          
  IrPrime2 = -2.0*Ip/(Up^2).*exp(1.0-Ud/Up) + ...
             (Ud*Ip)/(Up^3).*exp(1.0-Ud/Up) ...
              + A2^2*Iv*exp(A2*(Ud-Uv)) ...
              + Is/(Ut^2) * exp(Ud/Ut);
end




















