function yPrime = RobertsonFcn(t,y)
% Differential equations:
% du/dt = -0.04*u + 1e4*v.*w;
% dv/dt =  0.04*u - 1e4*v.*w - 3e7*v.*v;
% dw/dt =           3e7*v.*v;
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%     
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
% ---------------------------
yPrime(1) = -0.04*y(1) + 1e4*y(2).*y(3);
yPrime(2) =  0.04*y(1) - 1e4*y(2).*y(3) - 3e7*y(2).*y(2);
yPrime(3) =                               3e7*y(2).*y(2);
yPrime    = yPrime(:);


