function Jac = RobertsonJac(t,y)
% Differential equations:
% du/dt = -0.04*u + 1e4*v.*w;
% dv/dt =  0.04*u - 1e4*v.*w - 3e7*v.*v;
% dw/dt =           3e7*v.*v;
% Jac = [  -0.04    1e4*w             1e4*v
%           0.04   -1e4*w - 6e7*v     -1e4*v
%           0       6e7*v             0 ]
% ---------------------------
% See
%    E. Hairer S.P. Norsett G. Wanner
%    Solving Ordinary Differential Equations I
%    Nonstiff Problems
%    Springer Verlag
%    ISBN 3-540-17145-2, ISBN 0-387-17145-2
%    
%    E. Hairer G. Wanner
%    Solving Ordinary Differential Equations II
%    Stiff and Differential-Algebraic Problems
%    Springer Verlag
%    ISBN 3-540-53775-9 ISBN 0-387-53775-9
%     
% See also http://www.unige.ch/~hairer/software.html
% ---------------------------
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%   Denis Bichsel
%   Rue des Deurres 58
%   2000 Neuchtel
%   Suisse
%   dbichsel@infomaniak.ch
%   End of 2015
% ---------------------------

Jac      = zeros(3);
Jac(1,1) = -0.04; 
Jac(1,2) =  1e4*y(3); 
Jac(1,3) =  1e4*y(2);
Jac(2,1) =  0.04; 
Jac(2,2) = -1e4*y(3) - 6e7*y(2);
Jac(2,3) = -1e4*y(2);
Jac(3,1) = 0;
Jac(3,2) =             6e7*y(2);
Jac(3,3) = 0; 
