function gamma = coeff_comp(name)
%COEFF_COMP Set coefficients for the GNI_COMP integrator
%   Syntax: GAMMA = COEFF_COMP('NAME');
%
%   See also GNI_COMP
switch name
case '43',
	gamma = ones(3,1);
	qr2 = 2^(1/3);
	gamma(1) = 1/(2-qr2);
	gamma(2) = -qr2*gamma(1);
	gamma(3) = gamma(1);
case '45',
	gamma = ones(5,1);
	qr4 = 4^(1/3);
	gamma(1) = 1/(4-qr4);
	gamma(2) = gamma(1);
	gamma(3) = -qr4*gamma(1);
	gamma(4) = gamma(1);
	gamma(5) = gamma(1);
case '67',
	gamma = ones(7,1);
	gamma(1)= 0.78451361047755726381949763;
	gamma(2)= 0.23557321335935813368479318;
	gamma(3)=-1.17767998417887100694641568;
	gamma(4)= 1.31518632068391121888424973;
	gamma(5)=-1.17767998417887100694641568;
	gamma(6)= 0.23557321335935813368479318;
	gamma(7)= 0.78451361047755726381949763;
case '69',
	gamma = ones(9,1);
	gamma(1)= 0.39215846226558135393725811;
	gamma(2)= 0.33260288849639382848984234;
	gamma(3)=-0.70624607359230088534941023;
	gamma(4)= 0.08221272729243641010472095;
	gamma(5)= 0.79854399107577858563517766;
	gamma(6)= 0.08221272729243641010472095;
	gamma(7)=-0.70624607359230088534941023;
	gamma(8)= 0.33260288849639382848984234;
	gamma(9)= 0.39215846226558135393725811;
case '815',
	gamma = ones(8,1);
	gamma(1)= 0.74167036435061295344822780;
	gamma(2)=-0.40910082580003159399730010;
	gamma(3)= 0.19075471029623837995387626;
	gamma(4)=-0.57386247111608226665638773;
	gamma(5)= 0.29906418130365592384446354;
	gamma(6)= 0.33462491824529818378495798;
	gamma(7)= 0.31529309239676659663205666;
	gamma(8)=-0.79688793935291635401978884;
	gamma(9)= 0.31529309239676659663205666;
	gamma(10)= 0.33462491824529818378495798;
	gamma(11)= 0.29906418130365592384446354;
	gamma(12)=-0.57386247111608226665638773;
	gamma(13)= 0.19075471029623837995387626;
	gamma(14)=-0.40910082580003159399730010;
	gamma(15)= 0.74167036435061295344822780;
case '817',
	gamma = ones(17,1);
	gamma( 1)= 0.13020248308889008087881763;
	gamma( 2)= 0.56116298177510838456196441;
	gamma( 3)=-0.38947496264484728640807860;
	gamma( 4)= 0.15884190655515560089621075;
	gamma( 5)=-0.39590389413323757733623154;
	gamma( 6)= 0.18453964097831570709183254;
	gamma( 7)= 0.25837438768632204729397911;
	gamma( 8)= 0.29501172360931029887096624;
	gamma( 9)=-0.60550853383003451169892108;
	gamma(10)= 0.29501172360931029887096624;
	gamma(11)= 0.25837438768632204729397911;
	gamma(12)= 0.18453964097831570709183254;
	gamma(13)=-0.39590389413323757733623154;
	gamma(14)= 0.15884190655515560089621075;
	gamma(15)=-0.38947496264484728640807860;
	gamma(16)= 0.56116298177510838456196441;
	gamma(17)= 0.13020248308889008087881763;
case '1033',
	gamma = ones(33,1);
	gamma( 1)= 0.09040619368607278492161150;
	gamma( 2)= 0.53591815953030120213784983;
	gamma( 3)= 0.35123257547493978187517736;
	gamma( 4)=-0.31116802097815835426086544;
	gamma( 5)=-0.52556314194263510431065549;
	gamma( 6)= 0.14447909410225247647345695;
	gamma( 7)= 0.02983588609748235818064083;
	gamma( 8)= 0.17786179923739805133592238;
	gamma( 9)= 0.09826906939341637652532377;
	gamma(10)= 0.46179986210411860873242126;
	gamma(11)=-0.33377845599881851314531820;
	gamma(12)= 0.07095684836524793621031152;
	gamma(13)= 0.23666960070126868771909819;
	gamma(14)=-0.49725977950660985445028388;
	gamma(15)=-0.30399616617237257346546356;
	gamma(16)= 0.05246957188100069574521612;
	gamma(17)= 0.44373380805019087955111365;
	gamma(18)= 0.05246957188100069574521612;
	gamma(19)=-0.30399616617237257346546356;
	gamma(20)=-0.49725977950660985445028388;
	gamma(21)= 0.23666960070126868771909819;
	gamma(22)= 0.07095684836524793621031152;
	gamma(23)=-0.33377845599881851314531820;
	gamma(24)= 0.46179986210411860873242126;
	gamma(25)= 0.09826906939341637652532377;
	gamma(26)= 0.17786179923739805133592238;
	gamma(27)= 0.02983588609748235818064083;
	gamma(28)= 0.14447909410225247647345695;
	gamma(29)=-0.52556314194263510431065549;
	gamma(30)=-0.31116802097815835426086544;
	gamma(31)= 0.35123257547493978187517736;
	gamma(32)= 0.53591815953030120213784983;
	gamma(33)= 0.09040619368607278492161150;
case '21',
	gamma = 1;
otherwise,
	gamma = 1;
	error(['The method ''' lower(name) ''' is not implemented.']);
end

