C * * * * * * * * * * * * * * * 
C --- DRIVER FOR RADAR5 
C * * * * * * * * * * * * * * *
C       Use make command (relevant to Makefile)

        IMPLICIT REAL*8 (A-H,O-Z)

C --->  PARAMETERS FOR RADAR5 (FULL JACOBIAN) <---
  
        REAL*4 TARRAY(2)
        INTEGER, PARAMETER :: DP=kind(1D0)
C --->  PARAMETERS FOR RADAR5 (FULL JACOBIAN) <---
        INTEGER, PARAMETER :: ND=3
        INTEGER, PARAMETER :: NRDENS=1
        INTEGER, PARAMETER :: NGRID=11
        INTEGER, PARAMETER :: NLAGS=1
        INTEGER, PARAMETER :: NJACL=2
        INTEGER, PARAMETER :: MXST=10000
        INTEGER, PARAMETER :: LWORK=30
        INTEGER, PARAMETER :: LIWORK=30
        INTEGER, PARAMETER :: NPAR=4
        REAL(kind=DP), dimension(ND) :: Y
        REAL(kind=DP), dimension(NGRID+1) :: GRID
        REAL(kind=DP), dimension(LWORK) :: WORK
        INTEGER, dimension(LIWORK) :: IWORK
        INTEGER, dimension(NRDENS+1) :: IPAST
        REAL(kind=DP), dimension(NPAR) :: RPAR
        INTEGER, dimension(22) :: ISTAT
        EXTERNAL  FCN,PHI,ARGLAG,JFCN,JACLAG,SOLOUT

c ------ FILE DE DONNEES ----------
        OPEN(8,FILE='res_radar5')
c       OPEN(8,FILE='res_exact')
        REWIND 8

C       Parametri
        RPAR(1)=4.0D-2
        RPAR(2)=1.0D+4
        RPAR(3)=3.0D+7
        RPAR(4)=1.0D-2

C --- LOOP FOR DIFFERENT TOLERANCES
        NTOLMN=3
        NTOLMX=10
        NTOLDF=8
        NRLOOP=(NTOLMX-NTOLMN)*NTOLDF+1
        TOLST=0.1D0**NTOLMN
        TOLFC=0.1D0**(1.D0/NTOLDF)
C -----------------------------------------------------------------------
c       TOLST=1.D-9
c       NRLOOP=1
        DO 30 NTOL=1,NRLOOP

C       PRINT *,'Tolleranza = ',TOLST
C --- DIMENSION OF THE SYSTEM
        N=ND
C --- COMPUTE THE JACOBIAN ANALYTICALLY?
        IJAC=1
C --- JACOBIAN IS A FULL MATRIX
        MLJAC=N
C --- DIFFERENTIAL EQUATION IS IN IMPLICIT FORM?
      IMAS=0
      MLMAS=N
C     MUMAS=N

C --- OUTPUT ROUTINE IS USED DURING INTEGRATION
        IOUT=0
C --- INITIAL VALUES AND ENDPOINT OF INTEGRATION
        X=0.0D0
        Y(1)= 1.0D0
        Y(2)= 0.0D0 
        Y(3)= 0.0D0 
C       PRINT *,'Initial values',Y(1),Y(2)
C       Consistent with initial function
C --- ENDPOINT OF INTEGRATION
        XEND=1.0D+11
C --- REQUIRED (RELATIVE AND ABSOLUTE) TOLERANCE
        ITOL=0
        RTOL=TOLST
        ATOL=RTOL*1.D-5
C --- INITIAL STEP SIZE
        H=1.0D-6
C --- DEFAULT VALUES FOR PARAMETERS
        DO 10 I=1,20
        IWORK(I)=0
  10    WORK(I)=0.0D0  
C --- MAX NUMBER OF STEPS
        IWORK(2)=1000000
C --- WORKSPACE FOR PAST 
        IWORK(12)=MXST
C --- THE MAIN COMPONENT USES RETARDED ARGUMENT
        IWORK(15)=NRDENS
        IPAST(1)=2
C ---  USE AS GRID-POINTS
       IWORK(13)=NGRID
       DO I=1,NGRID
         GRID(I)=RPAR(4)*I
       END DO
C      CONTROL OF SIMPLIFIED NEWTON ITERATION
       IWORK(14)=1

C _____________________________________________________________________
C --- CALL OF THE SUBROUTINE RADAR5   
        CALL DTIME(TARRAY)
        CALL RADAR5(N,FCN,PHI,ARGLAG,X,Y,XEND,H,
     &                  RTOL,ATOL,ITOL,
     &                  JFCN,IJAC,MLJAC,MUJAC,
     &                  JACLAG,NLAGS,NJACL,
     &                  IMAS,SOLOUT,IOUT,
     &                  WORK,IWORK,RPAR,IPAR,IDID,
     &                  GRID,IPAST,FCN,MLMAS,MUMAS)
        CALL DTIME(TARRAY)

C --- PRINT SOLUTION
        WRITE (8,*) Y(1)
        WRITE (8,*) Y(2)
        WRITE (8,*) Y(3)
C --- PRINT STATISTICS
         DO J=13,20
            ISTAT(J)=IWORK(J)
         END DO
        WRITE(8,*)TARRAY(1)
        WRITE (8,*)(ISTAT(J),J=14,20)
        WRITE(6,*)' ***** TOL=',RTOL,'  ELAPSED TIME=',TARRAY(1),' ****'
        WRITE (6,91) (ISTAT(J),J=14,20)
        WRITE (6,92) ISTAT(13)
 91     FORMAT(' fcn=',I7,' jac=',I6,' step=',I6,
     &        ' accpt=',I6,' rejct=',I6,' dec=',I6,
     &        ' sol=',I7)
 92     FORMAT(' full Newt. its =',I7)
C -------- NEW TOLERANCE ---
        TOLST=TOLST*TOLFC

 30     CONTINUE

        STOP
        END
C
C
        SUBROUTINE SOLOUT (NR,XOLD,X,HSOL,Y,CONT,LRC,N,
     &                     RPAR,IPAR,IRTRN)
C       In questo esempio CONT (est. continua sul passo) 
C       ed LRC non occorrono
C ----- PRINTS SOLUTION AT EQUIDISTANT OUTPUT-POINTS
        IMPLICIT REAL*8 (A-H,O-Z)
        PARAMETER (XSTEP=0.5D0)
        DIMENSION Y(N),CONT(LRC)
        DIMENSION RPAR(*)
        EXTERNAL PHI
C       Rimane attiva XOUT
        COMMON /INTERN/XOUT

        WRITE (10,99) X,Y(1),Y(2),Y(3)
        RETURN
C
        IF (NR.EQ.1) THEN
           WRITE (6,99) X,Y(1),Y(2),Y(3)
           XOUT=XSTEP
        ELSE
           XOUT=X
C10        CONTINUE
C          IF (X.GE.XOUT) THEN
C --- CONTINUOUS OUTPUT FOR RADAU5
              WRITE (6,99) XOUT,
     &         CONTR5(1,N,XOUT,CONT,X,HSOL),
     &         CONTR5(2,N,XOUT,CONT,X,HSOL),
     &         CONTR5(3,N,XOUT,CONT,X,HSOL)
C             XOUT=XOUT+XSTEP
C             GOTO 10
C          END IF
        END IF
 99     FORMAT(1X,'X =',E18.10,'    Y =',4E18.10)
        RETURN
        END
C
        FUNCTION ARGLAG(IL,X,Y,RPAR,IPAR)
        IMPLICIT REAL*8 (A-H,O-Z)
        DIMENSION Y(*),RPAR(*),IPAR(*)
        SELECT CASE (IL)
        CASE (1)
C         ARGLAG=X
          ARGLAG=X-RPAR(4)
        CASE DEFAULT
          PRINT *,'Non-existent delay'
          STOP
        END SELECT
        RETURN
        END
C
        SUBROUTINE FCN(N,X,Y,F,ARGLAG,PHI,RPAR,IPAR,
     &                  PAST,IPAST,NRDS)
        IMPLICIT REAL*8 (A-H,K,O-Z)
        INTEGER, PARAMETER :: DP=kind(1D0)
        REAL(kind=DP), dimension(N) :: Y
        REAL(kind=DP), dimension(N) :: F
        REAL(kind=DP), dimension(1) :: PAST
        INTEGER, dimension(1) :: IPAST
        REAL(kind=DP), dimension(1) :: RPAR
        EXTERNAL PHI

        CALL LAGR5(1,X,Y,ARGLAG,PAST,THETA1,IPOS1,RPAR,IPAR)
        Y2L1=YLAGR5(2,THETA1,IPOS1,PHI,RPAR,IPAR,
     &              PAST,IPAST,NRDS)
        P=RPAR(3)

        F(1)=-RPAR(1)*Y(1)+RPAR(2)*Y2L1*Y(3) 
        F(2)= RPAR(1)*Y(1)-RPAR(2)*Y2L1*Y(3)-P*Y(2)**2         
        F(3)= P*Y(2)**2         

        RETURN
        END
C
        SUBROUTINE JFCN(N,X,Y,DFY,LDFY,ARGLAG,PHI,RPAR,IPAR,
     &                  PAST,IPAST,NRDS)
C ----- STANDARD JACOBIAN OF THE EQUATION
        IMPLICIT REAL*8 (A-H,K,O-Z)
        INTEGER, PARAMETER :: DP=kind(1D0)
        REAL(kind=DP), dimension(N) :: Y
        REAL(kind=DP), dimension(LDFY,N) :: DFY
        REAL(kind=DP), dimension(1) :: PAST
        INTEGER, dimension(1) :: IPAST
        REAL(kind=DP), dimension(1) :: RPAR
        EXTERNAL PHI

        CALL LAGR5(1,X,Y,ARGLAG,PAST,THETA1,IPOS1,RPAR,IPAR)
        Y2L1=YLAGR5(2,THETA1,IPOS1,PHI,RPAR,IPAR,
     &              PAST,IPAST,NRDS)
        P=RPAR(3)
C       Matrix J(3,3)

        DFY(1,1)=-RPAR(1)   
        DFY(1,2)= 0.D0        
        DFY(1,3)= RPAR(2)*Y2L1
        DFY(2,1)= RPAR(1)   
        DFY(2,2)= -2*P*Y(2)            
        DFY(2,3)=-RPAR(2)*Y2L1
        DFY(3,1)= 0.D0
        DFY(3,2)= 2*P*Y(2)
        DFY(3,3)= 0.D0
        RETURN
        END
C
        SUBROUTINE JACLAG(N,X,Y,DFYL,ARGLAG,PHI,IVE,IVC,IVL,
     &                    RPAR,IPAR,PAST,IPAST,NRDS)
C ----- JACOBIAN OF DELAY TERMS IN THE EQUATION
        IMPLICIT REAL*8 (A-H,O-Z)
        INTEGER, PARAMETER :: DP=kind(1D0)
        REAL(kind=DP), dimension(N) :: Y
        REAL(kind=DP), dimension(1) :: DFYL
        REAL(kind=DP), dimension(1) :: PAST
        INTEGER, dimension(1) :: IPAST
        REAL(kind=DP), dimension(1) :: RPAR
        INTEGER, dimension(1) :: IVE,IVC,IVL
        EXTERNAL PHI
        
        IVL(1)=1
        IVE(1)=1
        IVC(1)=2
        IVL(2)=1
        IVE(2)=2
        IVC(2)=2
        DFYL(1)= RPAR(2)*Y(3)
        DFYL(2)=-RPAR(2)*Y(3)

        RETURN
        END

C
        FUNCTION PHI(I,X,RPAR,IPAR)
        IMPLICIT REAL*8 (A-H,O-Z)
        INTEGER, PARAMETER :: DP=kind(1D0)
        REAL(kind=DP), dimension(1) :: RPAR

        PHI=0.0D0 
        RETURN
        END
