library(car)
library(emmeans)
library(MASS)
library(MVTests)

########################################
## REPEATED MEASURES (M)ANOVA
########################################

## LOADING THE DATA
darts <- read.table("https://drive.switch.ch/index.php/s/Tym4l1XhHG37UbT/download",header=TRUE,sep=",",as.is=FALSE)


## INSPECTING THE DATA
head(darts)
dim(darts)
str(darts)
table(darts$Hero,darts$Throw)
aggregate(Points~Hero,data=darts,FUN=mean)


## LONG FORMAT TO WIDE FORMAT
darts.wide <- reshape(darts,direction="wide",v.names="Points",timevar="Throw",idvar=c("Observation","Hero"))
darts.wide
cor(darts.wide[,3:5])


## REPEATED MEASURES ANOVA
within.design <- data.frame(Throw=as.factor(c("T1","T2","T3")))

model <- lm(cbind(Points.T1,Points.T2,Points.T3)~1,data=darts.wide)
result <- Anova(model,type=2,test="Wilks",idesign=~Throw,idata=within.design)
result
summary(result)

reference <- ref_grid(model, mult.names="Throw")
pairs(reference, adjust="none")


########################################
## EXTENSIONS FOR REPEATED MEASURES (M)ANOVA
########################################

## CLASSICAL MANOVA
set.seed(238)
radio <- data.frame(Sample=paste("S",1:50,sep=""), Source=rep(c("Chernobyl","Rostov"),each=25),
  Cs137=c(rnorm(25,0.6,0.01),rnorm(25,0.1,0.05)), I131=c(rnorm(25,0.7,0.01),rnorm(25,0.15,0.05)),
  C14=rnorm(50,0.9,0.01), Zr95=abs(rnorm(50,0,0.001)))

mult <- lm(cbind(Cs137,I131,C14,Zr95)~Source, data=radio)
maov <- manova(mult)
summary(maov, test="Wilks", intercept=TRUE)

## MANOVA ASSUMPTIONS
mah.dist <- mahalanobis(radio[,3:6],center=colMeans(residuals(mult)), cov=cov(radio[,3:6]))
qqnorm(mah.dist,pch=4) ; qqline(mah.dist)

BoxM(radio[,3:6],group=radio$Source)


## PAIRED T-TEST
mind <- read.table("https://drive.switch.ch/index.php/s/rPxOLMV1b8w2DC3/download",header=TRUE,as.is=FALSE)
Diff <- mind$T1_Anx-mind$T2_Anx

t.test(mind$T1_Anx,mind$T2_Anx,paired=TRUE)
t.test(Diff)
summary(lm(Diff~1))

## PAIRED T-TEST AS RM-MANOVA
mult <- lm(cbind(T1_Anx,T2_Anx)~1,data=mind)
within.design <- data.frame(Time=as.factor(c("T1","T2")))

Anova(mult, type=2, test="Wilks", idesign=~Time, idata=within.design)


## 2X2 RM-MANOVA
set.seed(999)
twobytwo <- as.data.frame(matrix(rnorm(30*4),30,4))
colnames(twobytwo) <- c("A1_B1","A1_B2","A2_B1","A2_B2")

mult <- lm(cbind(A1_B1,A1_B2,A2_B1,A2_B2)~1, data=twobytwo)
within.design <- data.frame(A=as.factor(c(1,1,2,2)),B=as.factor(c(1,2,1,2)))

Anova(mult, type=2, test="Wilks", idesign=~A*B, idata=within.design)


## 3-LEVEL RM-MANOVA
mind <- read.table("https://drive.switch.ch/index.php/s/rPxOLMV1b8w2DC3/download",header=TRUE,as.is=FALSE)
head(mind[sample(1:36),])

mind$D12 <- mind$T1_Anx-mind$T1_Sad
mind$D13 <- mind$T1_Anx-mind$T1_Joy
mind$D23 <- mind$T1_Sad-mind$T1_Joy

mlm <- lm(cbind(D12,D13)~1,data=mind)
summary(manova(mlm),intercept=TRUE)
mlm <- lm(cbind(D12,D23)~1,data=mind)
summary(manova(mlm),intercept=TRUE)
mlm <- lm(cbind(D13,D23)~1,data=mind)
summary(manova(mlm),intercept=TRUE)

mlm <- lm(cbind(T1_Anx,T1_Sad,T1_Joy)~1,data=mind)
within.design <- data.frame(Emotion=as.factor(c("Anxiety","Sadness","Joy")))
Anova(mlm,test="Pillai",idesign=~Emotion,idata=within.design)


## BETWEEN-SUBJECTS COVARIATES
mind <- read.table("https://drive.switch.ch/index.php/s/rPxOLMV1b8w2DC3/download",header=TRUE,as.is=FALSE)




