library(foreach)
library(lme4)
library(lmerTest)
library(lattice)
library(r2glmm)
library(boot)
library(visreg)
library(effectsize)
library(parameters)
library(MuMIn)
spl <- function(v,k=0,c=FALSE) {
  if(c==TRUE) { v <- foreach(i=k,.combine="cbind") %do% { ifelse(v<i,0,1) } }
  if(c==FALSE) { v <- foreach(i=k,.combine="cbind") %do% { ifelse(v<i,0,v-i) } }
  v
}
source("https://drive.switch.ch/index.php/s/ZjAezR7ehy7xZhP/download")

################################################
## LONGITUDINAL DATA ANALYSIS
################################################

## LOADING AND INSPECTING THE DATA
ponies <- read.table("https://drive.switch.ch/index.php/s/EhA63ePqbJrqUod/download",header=TRUE,sep=",",as.is=FALSE)
ponies[1:10,]
dim(ponies)
str(ponies)

## REMOVE CASES WITH MISSING SALES DATA
ponies <- ponies[complete.cases(ponies),]

## VISUALIZING THE DATA (RUN ALL TOGETHER)
plot(Sales~Time,data=ponies,pch="+",col="plum3",ylim=c(0,50),ylab="Number of Robot Ponies sold",xlab="Days since tracking")
points(Sales~Time,data=ponies,subset=Store=="S20",pch=15,col="darkblue")
lines(aggregate(Sales~Time,data=ponies,FUN=mean),col="violetred3",lwd=3)
abline(v=29,lty=2)
legend("topleft",legend=c("Average sales per day","Start of campaign"),lwd=c(3,1),seg.len=2.5,col=c("violetred4","black"),lty=c(1,2),bty="n")
legend("topright",legend=c("All stores","Store 20"),pch=c(3,15),col=c("plum4","darkblue"),pt.cex=1.2,bty="n")


## CATEGORICAL TIME (PAIRED T-TEST)
ponies$Phase <- as.factor(ifelse(ponies$Time>30,"T2_post","T1_pre"))
ponies$Day <- as.factor(ponies$Time)
ponies$Week <- as.factor(rep(paste("Week ",rep(1:9,times=c(6,6,6,6,6,6,6,6,4)),sep=""),times=30))
sales.averaged <- aggregate(Sales~Phase+Store,data=ponies,FUN=mean)
t.test(Sales~Phase,data=sales.averaged,paired=TRUE)


## CATEGORICAL TIME (2 LEVELS)
catmod1 <- lmer(Sales~Phase+(1+Phase|Store),data=ponies,REML=FALSE)
summary(catmod1)
visreg(catmod1,xvar="Phase")
r.squaredGLMM(catmod1) ; AIC(catmod1)

catmod1 <- lmer(Sales~spl(Time,k=30,c=TRUE)+(0+spl(Time,k=30,c=TRUE)|Store),data=ponies,REML=FALSE)
summary(catmod1)
visreg(catmod1,xvar="Time")

plot(Sales~Time,data=ponies,pch="+",col="plum3",ylim=c(0,50),xlab="Time",ylab="Number of Robot Ponies sold")
population <- aggregate(fitted(catmod1)~ponies$Time,FUN=mean) ; population$"fitted(catmod1)"[27] <- NA
store20 <- fitted(catmod1)[ponies$Store=="S20"] ; store20[27] <- NA
store27 <- fitted(catmod1)[ponies$Store=="S27"] ; store27[27] <- NA
lines(population,lwd=3,col="violetred4")
lines(store20~ponies$Time[ponies$Store=="S20"],lwd=3,col="darkblue")
lines(store27~ponies$Time[ponies$Store=="S27"],lwd=2,col="darkgoldenrod")
abline(v=30,lty=2)
legend("topleft",legend=c("Population trend","Store 20 trend","Store 27 trend","Start of campaign"),
 lwd=c(3,3,3,1),seg.len=2.5,col=c("violetred4","darkblue","darkgoldenrod","black"),lty=c(1,1,1,2),bty="n")

## CATEGORICAL TIME (9 LEVELS: WEEK)
contrasts(ponies$Week) <- contr.treatment(levels(ponies$Week),base=5)
catmod2 <- lmer(Sales~Week+(1+Week|Store),data=ponies, REML=FALSE)
summary(catmod2)
anova(catmod2,type=2)
difflsmeans(catmod2)
parameters(catmod2,standardize="refit")
visreg(catmod2,xvar="Week")
r.squaredGLMM(catmod2) ; AIC(catmod2)

catmod4 <- lmer(Sales~spl(Time,k=c(6,13,20,27,34,41,48,55),c=TRUE)+(1+spl(Time,k=c(6,13,20,27,34,41,48,55),c=TRUE)|Store),data=ponies, REML=FALSE)
summary(catmod4)
visreg(catmod4,xvar="Time")

plot(Sales~Time,data=ponies,pch="+",col="plum3",ylim=c(0,50),xlab="Time",ylab="Number of Robot Ponies sold")
population <- aggregate(fitted(catmod4)~ponies$Time,FUN=mean) ; population$"fitted(catmod4)"[c(7,13,19,25,31,37,43,49)] <- NA
store20 <- fitted(catmod4)[ponies$Store=="S20"] ; store20[c(7,13,19,25,31,37,43,49)] <- NA
store27 <- fitted(catmod4)[ponies$Store=="S27"] ; store27[c(7,13,19,25,31,37,43,49)] <- NA
lines(population,lwd=4,col="violetred4")
lines(store20~ponies$Time[ponies$Store=="S20"],lwd=2,col="darkblue")
lines(store27~ponies$Time[ponies$Store=="S27"],lwd=2,col="darkgoldenrod")
abline(v=30,lty=2)
legend("topleft",legend=c("Population trend","Store 20 trend","Store 27 trend","Start of campaign"),
 lwd=c(3,3,3,1),seg.len=2.5,col=c("violetred4","darkblue","darkgoldenrod","black"),lty=c(1,1,1,2),bty="n")

## CATEGORICAL TIME (60 LEVELS: WEEK)
catmod3 <- lmer(Sales~Day+(1|Store),data=ponies, REML=FALSE)
summary(catmod3)
anova(catmod3,type=2)
difflsmeans(catmod3)
visreg(catmod3,xvar="Day")
r.squaredGLMM(catmod3) ; AIC(catmod3)


catmod5 <- lmer(Sales~spl(Time,k=1:59,c=TRUE)+(1|Store),data=ponies, REML=FALSE)
visreg(catmod5,xvar="Time")

plot(Sales~Time,data=ponies,pch="+",col="plum3",ylim=c(0,50),xlab="Time",ylab="Number of Robot Ponies sold")
population <- aggregate(fitted(catmod5)~ponies$Time,FUN=mean)
store20 <- fitted(catmod5)[ponies$Store=="S20"]
store27 <- fitted(catmod5)[ponies$Store=="S27"]
lines(population,lwd=4,col="violetred4")
lines(store20~ponies$Time[ponies$Store=="S20"],lwd=2,col="darkblue")
lines(store27~ponies$Time[ponies$Store=="S27"],lwd=2,col="darkgoldenrod")
abline(v=30,lty=2)
legend("topleft",legend=c("Population trend","Store 20 trend","Store 27 trend","Start of campaign"),
 lwd=c(3,3,3,1),seg.len=2.5,col=c("violetred4","darkblue","darkgoldenrod","black"),lty=c(1,1,1,2),bty="n")

## QUADRATIC POLYNOMIAL REGRESSION
quadmod <- lmer(Sales~Time+I(Time^2)+(1+Time+I(Time^2)|Store),data=ponies)
summary(quadmod)


### SCALING OF TIME IS NECESSARY
ponies$Time.z <- scale(ponies$Time)
quadmod <- lmer(Sales~Time.z+I(Time.z^2)+(1+Time.z+I(Time.z^2)|Store),data=ponies, REML=FALSE)
summary(quadmod)
r.squaredGLMM(quadmod) ; AIC(quadmod)


## PIECEWISE REGRESSION WITH SPLINES
ponies$Time.s <- ifelse(ponies$Time.z<0.03, 0, ponies$Time.z-0.03)
splinemod <- lmer(Sales~Time.z+Time.s+(1+Time.z+Time.s||Store),data=ponies, REML=FALSE)
summary(splinemod)
r.squaredGLMM(splinemod) ; AIC(splinemod)
ranova(splinemod)

## COMPARISON OF POLYNOMIAL FIT VERSUS SPLINE FIT
par(mfrow=c(2,1))
plot(Sales~I(scale(Time)),data=ponies,pch="+",col="plum3",ylim=c(0,50),xlab="Standardized time",ylab="Number of Robot Ponies sold")
lines(aggregate(fitted(quadmod)~ponies$Time.z,FUN=mean),lwd=4,col="violetred4")
lines(fitted(quadmod)[ponies$Store=="S20"]~ponies$Time.z[ponies$Store=="S20"],lwd=2,col="darkblue")
lines(fitted(quadmod)[ponies$Store=="S27"]~ponies$Time.z[ponies$Store=="S27"],lwd=2,col="darkgoldenrod")
abline(v=0.03,lty=2)
legend("topleft",legend=c("Population trend","Store 20 trend","Store 27 trend","Start of campaign"),
 lwd=c(3,3,3,1),seg.len=2.5,col=c("violetred4","darkblue","darkgoldenrod","black"),lty=c(1,1,1,2),bty="n")
plot(Sales~I(scale(Time)),data=ponies,pch="+",col="plum3",ylim=c(0,50),xlab="Standardized time",ylab="Number of Robot Ponies sold")
lines(aggregate(fitted(splinemod)~ponies$Time.z,FUN=mean),lwd=4,col="violetred4")
lines(fitted(splinemod)[ponies$Store=="S20"]~ponies$Time.z[ponies$Store=="S20"],lwd=2,col="darkblue")
lines(fitted(splinemod)[ponies$Store=="S27"]~ponies$Time.z[ponies$Store=="S27"],lwd=2,col="darkgoldenrod")
abline(v=0.03,lty=2)
legend("topleft",legend=c("Population trend","Store 20 trend","Store 27 trend","Start of campaign"),
 lwd=c(3,3,3,1),seg.len=2.5,col=c("violetred4","darkblue","darkgoldenrod","black"),lty=c(1,1,1,2),bty="n")


## ADDING A GROUPING VARIABLE
splinemod <- lmer(Sales~Location*(Time+spl(Time,k=30))+(1+Time+spl(Time,k=30)||Store),data=ponies, REML=FALSE)
anova(splinemod,type=2)
summary(splinemod)

visreg(splinemod,xvar="Time",by="Location",overlay=TRUE,points.par=list(col="plum3",pch="+",cex=0.8),line.par=list(col=c("violetred3","blueviolet"),lwd=4))

################################################
## BOOTSTRAPPING RANDOM EFFECS
################################################

## BOOTSTRAP TESTING
ponies <- read.table("https://drive.switch.ch/index.php/s/EhA63ePqbJrqUod/download",header=TRUE,sep=",")
set.seed(1502)
ponies$Sales[ponies$Store=="S11"][31:60] <- round(seq(14,2,length=30)+rnorm(30,0,2))
ponies$Time.z <- scale(ponies$Time)
ponies$Time.s <- ifelse(ponies$Time.z<0.03, 0, ponies$Time.z-0.03)

splinemod <- lmer(Sales~Time.z+Time.s+(1+Time.z+Time.s||Store),data=ponies)
summary(splinemod)
coef(splinemod)$Store

coef.out <- function(merMod) { coef(merMod)$Store[,3] }
set.seed(59)
system.time(boot.out <- bootMer(splinemod,FUN=coef.out,nsim=9999,use.u=TRUE,type="parametric"))
confint(boot.out,method="boot",boot.type="perc",level=0.999)

coef.out <- function(merMod) { coef(merMod)$Store[,2]+coef(merMod)$Store[,3] }
set.seed(59)
system.time(boot.out <- bootMer(splinemod,FUN=coef.out,nsim=9999,use.u=TRUE,type="parametric"))
confint(boot.out,method="boot",boot.type="perc",level=0.999)
