library(vcd)
library(DescTools)
source("C:/filepath/square_tests.r")

## INTERVENTION STUDY
pills <- array(c(51,48,12,89),dim=c(2,2),dimnames=list(Pill_T1=c("Blue","Red"),Pill_T2=c("Blue","Red")))
pills
margin.table(pills,1) ; margin.table(pills,2)

chisq.test(pills)
fisher.test(pills)
mosaic(pills,shade=TRUE,rot_labels=c(90,90,0,0),just_labels=c("left","right"),varnames=c(FALSE,FALSE),gp_labels=gpar(fontsize=12,fontface=2))

chisq.test(matrix(c(99,101,63,137),2,2))

mcnemar.test(pills)
CohenKappa(pills)

prop.test(63,200)
prop.test(99,200)
prop.test(48,60)

square.tests(pills)

age <-  array(c(9,3,14,34),dim=c(2,2),dimnames=list(Age=c("Young","Old"),T1_T2=c("Blue-Red","Red-Blue")))
chisq.test(age)
prop.test(9,9+14)
prop.test(3,3+34)


## RATER AGREEMENT
regul <- matrix(c(22,0,0,0,0,1,0,2,0,32,6,0,0,0,0,4,0,8,50,12,0,7,0,0,0,0,9,28,0,2,0,3,0,1,0,0,47,10,0,0,2,0,2,1,15,23,0,0,0,0,0,0,0,0,5, 1,2,1,0,4,0,0,0,19), 8,8)
rownames(regul) <- c("Avoidance","Problem solving","Reappraisal","Humor","Relaxation","Acceptance","Suppression","Social support") ; colnames(regul) <- rownames(regul)
regul
margin.table(regul,1) ; margin.table(regul,2)

chisq.test(regul)
mosaic(regul,shade=TRUE,rot_labels=c(90,90,0,0),just_labels=c("left","right"),varnames=c(FALSE,FALSE),gp_labels=gpar(fontsize=12,fontface=2))
square.tests(regul)

CohenKappa(regul,conf.level=0.95)

out <- square.tests(regul)
mosaic(regul+1,shade=TRUE,expected=out$Fitted$Qindependence+1,df=41,direction=c("v","h"),mar=c(5,5,5,5),
 rot_labels=c(90,90,0,0),just_labels=c("left","right"),varnames=c(FALSE,FALSE),gp_labels=gpar(fontsize=12,fontface=2))


## MODEL PERFORMANCE
got <- array(c(11,54,11,132),dim=c(2,2),dimnames=list(Observed=c("No","Yes"),Predicted=c("No","Yes")))
got
margin.table(got,1) ; margin.table(got,2)

CohenKappa(got,conf.level=0.95)
chisq.test(got)
square.tests(got)