library(foreach)
library(gtools)
MCC <- function(V) {
 nms <- colnames(V)
 d <- combinations(nrow(V),2,1:nrow(V))
 out <- foreach(i=1:nrow(d),.combine="c") %do% { 
   k <- d[i,1]
   m <- d[i,2]
   (V[k,k]*V[m,m]-V[k,m]*V[m,k])/(sqrt(V[k,k]+V[k,m])*sqrt(V[k,k]+V[m,k])*sqrt(V[m,m]+V[k,m])*sqrt(V[m,m]+V[m,k]))
 }
 out[is.na(out)] <- 0
 mat <- matrix(0,nrow(V),nrow(V))
 mat[lower.tri(mat)] <- out
 mat <- t(mat)
 mat[lower.tri(mat)] <- out
 mat <- t(mat)
 attr(mat,"values") <- out
 diag(mat) <- 0
 colnames(mat) <- nms
 rownames(mat) <- nms
 mat
}