###############################################
## MACHINE LEARNING WORKSHOP
## SCRIPT 01 - INTRODUCTION
###############################################

## IF YOU HAVE NOT INSTALLED ALL PACKAGES YET
install.packages(c("AdaptiveSparsity","altR2","car","DAAG","earth","foreach","ipred","glmnet","gtools","kknn","klaR",
  "ks","maptree","MASS","mclust","mda","nnet","olsrr","plotmo","psych","randomForest","rpart","rpart.plot","visreg"))

## R PRIMER
set.seed(666)
rdat <- as.data.frame(matrix(rnorm(5000*101),5000,101))
colnames(rdat) <- c("Y",paste("X",1:100,sep=""))

head(rdat)
dim(rdat)

lin <- lm(Y ~ 1 + X1 + X2, data=rdat)

lin <- lm(Y~.,data=rdat)
summary(lin)

library(car)
Anova(lin,type=2)

fitted(lin)
predict(lin)

library(visreg)
par(mfrow=c(1,2),mar=c(5,5,1,1))
visreg(lin,xvar="X1",line.par=list(col="darkblue",lwd=3),points.par=list(pch=4,col="bisque3",cex=0.5),fill.par=list(col="lightblue"))
visreg(lin,xvar="X33",line.par=list(col="darkblue",lwd=3),points.par=list(pch=4,col="bisque3",cex=0.5),fill.par=list(col="lightblue"))


