###############################################
## MACHINE LEARNING WORKSHOP
## SCRIPT 06 - DISCRIMINANTS
###############################################

## LOAD REQUIRED PACKAGES
library(MASS)
library(foreach)
library(mda)
library(mclust)
library(ks)
library(klaR)


## DISCRIMINANTS
train <- read.csv("https://drive.switch.ch/index.php/s/8nNrBeeIOxilaKP/download",header=TRUE,as.is=FALSE)
head(train) ; dim(train)
test <- read.csv("https://drive.switch.ch/index.php/s/wS6WmzMYCMTRgzH/download",header=TRUE,as.is=FALSE)
head(test) ; dim(test)

par(mfrow=c(1,2))
plot(train[,1:2],col=as.character(train[,3]),xlim=range(test$X1),ylim=range(test$X2),pch=18,cex=1.2)
plot(test[,1:2],col=as.character(test[,3]),pch="x")


### LINEAR DISCRIMINANT ANALYSIS
ld <- lda(Class~X1+X2,data=train)
ld
mean(predict(ld)$class!=train$Class)

ld.cv <- lda(Class~X1+X2,data=train,CV=TRUE)
ld.cv$class
mean(ld.cv$class!=train$Class)

par(mar=c(5,5,1,1),cex.axis=1.2,cex.lab=1.5,mfrow=c(1,2))
plot(test[,1:2],col=as.character(test[,3]),pch="~")
points(train[,1:2],col=as.character(train[,3]),pch=18,cex=1.2)
plot(test[,1:2],col=as.character(predict(ld,newdata=test,type="class")$class),pch="~")
points(ld$means,col=c("blue","green"),pch=18,cex=2.5)

ld.pred <- predict(ld,newdata=test)$class
mean(ld.pred!=test$Class)

ld

### QUADRATIC DISCRIMINANT ANALYSIS
qd <- qda(Class~X1+X2,data=train)
qd
mean(predict(qd)$class!=train$Class)
mean(predict(qd,newdata=test)$class!=test$Class)

par(mar=c(5,5,1,1),cex.axis=1.2,cex.lab=1.5,mfrow=c(1,2))
plot(test[,1:2],col=as.character(test[,3]),pch="~")
points(train[,1:2],col=as.character(train[,3]),pch=18,cex=1.2)
plot(test[,1:2],col=as.character(predict(qd,newdata=test,type="class")$class),pch="~")
points(qd$means,col=c("blue","green"),pch=18,cex=2.5)


## MIXTURE DISCRIMINANT ANALYSIS
set.seed(1985)
folds <- sample(rep(1:3,each=66))
combinations <- expand.grid(blue=1:6,green=1:6)
	
errors <- foreach(i=1:nrow(combinations),.combine="c") %do% {
 cv <- mean(foreach(j=1:3,.combine="c") %do% { 
   md <- mda(Class~X1+X2,data=train,subset=which(folds!=j),subclasses=unlist(combinations[i,]),dimension=2,start.method="lvq")
   pred <- predict(md,newdata=train[which(folds==j),],type="class")
   mean(pred!=train$Class[which(folds==j)])
 })
}

min(errors) ; combinations[which.min(errors),]
filled.contour(x=1:6,y=1:6,z=matrix(errors,6,6),nlevels=40)

md <- mda(Class~X1+X2,data=train,subclasses=c(3,3))
pred <- predict(md,newdata=test,type="class")
mean(pred!=test$Class)

par(mar=c(5,5,1,1),cex.axis=1.2,cex.lab=1.5,mfrow=c(1,2))
plot(test[,1:2],col=as.character(test[,3]),pch="~")
points(train[,1:2],col=as.character(train[,3]),pch=18,cex=1.2)
plot(test[,1:2],col=as.character(pred),pch="~")

set.seed(1177)
mcda <- MclustDA(data=train[,-3],class=train[,3])
summary(mcda)
pred <- predict(mcda)$class
mean(pred!=train$Class)
pred <- predict(mcda,newdata=test[,-3])$class
mean(pred!=test$Class)

par(mar=c(5,5,1,1),cex.axis=1.2,cex.lab=1.5,mfrow=c(1,2))
plot(test[,1:2],col=as.character(test[,3]),pch="~")
points(train[,1:2],col=as.character(train[,3]),pch=18,cex=1.2)
plot(test[,1:2],col=as.character(pred),pch="~")
points(rbind(t(mcda$models$blue$parameters$mean),t(mcda$models$green$parameters$mean)),col=c("blue","green","green"),pch=18,cex=2.5)

tmp <- MclustDA(train[,-3],class=train$Class,G=1, modelType="EDDA", modelNames="VVV")
plot(tmp,what=c("scatterplot"),col=adjustcolor(c("blue","green"),alpha=0.7),symbols=c(18,18),lwd=3)

mc <- Mclust(train[,-3])
mc
plot(mc)
pred <- predict(mc,newdata=test[,-3])$class

par(mar=c(5,5,1,1),cex.axis=1.2,cex.lab=1.5,mfrow=c(1,2))
plot(test[,1:2],col=as.character(test[,3]),pch="~")
points(train[,1:2],col=as.character(train[,3]),pch=18,cex=1.2)
plot(test[,1:2],col=ifelse(pred==2,"darkorange","darkcyan"),pch="~")


## KERNEL DISCRIMINANT ANALYSIS
set.seed(997)
bndwdth <- Hkda.diag(train[,1:2],train$Class, pre="scale")
kd <- kda(x=train[,-3],x.group=train[,3],Hs=bndwdth,eval.points=test[,-3])
mean(kd$x.group.est!=test$Class)

par(mar=c(5,5,1,1),cex.axis=1.2,cex.lab=1.5,mfrow=c(1,2))
plot(kd,y=test[,-3],col=c("blue","green"))
plot(test[,1:2],col=as.character(kd$x.group.est),pch="~")


## NAIVE BAYES CLASSIFIER
nb <- NaiveBayes(Class~X1+X2,data=train,usekernel=TRUE,adjust=0.8)
nb.pred <- predict(nb,newdata=test)$class
mean(nb.pred!=test$Class)

par(mar=c(5,5,1,1),cex.axis=1.2,cex.lab=1.5,mfrow=c(1,2))
plot(test[,1:2],col=as.character(test[,3]),pch="~")
points(train[,1:2],col=as.character(train[,3]),pch=18,cex=1.2)
plot(test[,1:2],col=as.character(nb.pred),pch="~")





