###############################################
## MACHINE LEARNING WORKSHOP
## SCRIPT 09 - PRACTICAL - ML COMPETITION
###############################################

## LOAD REQUIRED PACKAGES
library(psych)
library(visreg)
library(plotmo)
library(car)
library(rgl)
library(MASS)
library(kknn)
library(earth)
library(rpart)
library(randomForest)

############################################
## DATA PROBLEM 1 - HIDDEN PATTERN
############################################

## READ AND INSPECT DATA
prob1 <- read.table("https://drive.switch.ch/index.php/s/2AZqHZdhMle3Ipj/download",header=TRUE,as.is=FALSE)
head(prob1) ; dim(prob1)
str(prob1)

describe(prob1)
pairs(prob1[,-4],col=adjustcolor(rep(c("darkcyan","bisque3"),each=1000),alpha=0.6),pch=4)
boxplot(prob1)

scatter3d(Y~X+Z|G,data=prob1,point.col=c("darkcyan","darkorange"),surface.alpha=0,square.col="white",surface=FALSE) # ROTATABLE 3D PLOT

## SIMPLE REGRESSION MODEL
lr <- glm(G~X+Y+Z, data=prob1, family=binomial)
summary(lr)
visreg(lr,scale="response")


############################################
## DATA PROBLEM 2 - MEDICAL RARITY
############################################

## READ AND INSPECT DATA
prob2 <- read.table("https://drive.switch.ch/index.php/s/6AwbHhlQtctXHlz/download",header=TRUE,as.is=FALSE)
head(prob2) ; dim(prob2)
str(prob2)

describe(prob2)
boxplot(prob2)

## SIMPLE REGRESSION MODEL
lr <- glm(G~., data=prob2, family=binomial)
summary(lr)

## CLASS WEIGHTING
table(prob2$G)
wf <- function(fact) { rep(1/(proportions(table(fact))*sum(nlevels(fact))),times=table(fact)) }

lr <- glm(G~., data=prob2, family=binomial, weights=wf(G))
tree <- rpart(G~., data=prob2, weights=wf(G))
mars <- earth(G~., data=prob2, glm=list(family=binomial), degree=2, pmethod="cv", weights=wf(G), nfold=5, trace=1)

ld <- lda(G~.,data=prob2, prior=c(0.50,0.50), CV=TRUE)
rf <- randomForest(G~., data=prob2, ntree=500, sampsize=c(50,50))


############################################
## DATA PROBLEM 3 - FEAR OF HEIGHTS IN VR
############################################

## READ AND INSPECT DATA
prob3 <- read.table("https://drive.switch.ch/index.php/s/vRp5qjDyPOVsjlr/download",header=TRUE)
head(prob3) ; dim(prob3)
str(prob3)

describe(prob3)
pairs(prob3)
boxplot(prob3)

## SIMPLE REGRESSION MODEL
lr <- lm(feel_fear~.-subject, data=prob3)
lr <- lm(feel_fear~depth-subject, data=prob3)

summary(lr)
visreg(lr)


############################################
## TEST DATA URLS
############################################

test.prob1 <- read.table("https://drive.switch.ch/index.php/s/E8e99nQBGKFiizM/download",header=TRUE,as.is=FALSE)
test.prob2 <- read.table("https://drive.switch.ch/index.php/s/kYLYZ6eonZ99It7/download",header=TRUE,as.is=FALSE)
test.prob3 <- read.table("https://drive.switch.ch/index.php/s/Oof3pKcCqtY7IYV/download",header=TRUE,as.is=FALSE)