###############################################
## MACHINE LEARNING WORKSHOP
## SCRIPT 02 - GENERALIZATION
###############################################

## REQUIRED PACKAGES
library(olsrr)
library(altR2)
library(DAAG)


## STEPWISE SELECTION WITH AIC
phobia <- read.table("https://drive.switch.ch/index.php/s/5HiEn1NDoAbEci4/download",header=TRUE,as.is=FALSE)

initial.model <- lm(acrophobia~.,data=phobia)
stepwise <- ols_step_forward_aic(initial.model)
stepwise ; plot(stepwise)

summary(stepwise$model)


## MODEL SELECTION AND GENERALIZATION
set.seed(668)
x <- 1:500
true <- 100*sin(0.02*x) + 0.5*x
y <- true + rnorm(500,0,25)
	
par(mar=c(5,5,1,1),cex.lab=1.2,cex.axis=1.2)
plot(x,y,pch="+",col="grey70",lwd=2,xlab="X",ylab="Y")
lines(x,true,col="darkmagenta")

toy <- lm(y~x)
summary(toy)

altR2(toy)
AIC(toy)
BIC(toy)
press(toy)

N <- length(x)
sqrt(press(toy)/N)

poly <- lm(y~x+I(x^2)+I(x^3)+I(x^4))
poly <- lm(y~poly(x,4))
summary(poly)

altR2(poly)
AIC(toy) ; AIC(poly)
BIC(toy) ; BIC(poly)

plot(x,y,pch="+",col="grey70",xlab="X",ylab="Y",cex=1.2)
lines(x,true,col="darkmagenta",lwd=2.2)
lines(x,fitted(poly),col="blue",lwd=3)