###############################################
## MACHINE LEARNING WORKSHOP
## SCRIPT 08 - TREES
###############################################

## LOAD REQUIRED PACKAGES
library(rpart)
library(rpart.plot)
library(randomForest)


## CLASSIFICATION TREES
train <- read.csv("https://drive.switch.ch/index.php/s/8nNrBeeIOxilaKP/download",header=TRUE,as.is=FALSE)
head(train) ; dim(train)
test <- read.csv("https://drive.switch.ch/index.php/s/wS6WmzMYCMTRgzH/download",header=TRUE,as.is=FALSE)
head(test) ; dim(test)

par(mar=c(5,5,1,1),cex.axis=1.2,cex.lab=1.5,mfrow=c(1,2))
plot(test[,1:2],col=as.character(test[,3]),pch="~")
points(train[,1:2],col=as.character(train[,3]),pch=18,cex=1.2)
plot(test[,1:2],col=as.character(test[,3]),pch="~")

tree <- rpart(Class~.,data=train)
mean(predict(tree,test,type="class")!=test$Class)
rpart.plot(tree,type=3,fallen.leaves=FALSE,box.palette=list("steelblue1","palegreen"),legend.x=0.8,legend.y=1)

par(mar=c(5,5,1,1),cex.axis=1.2,cex.lab=1.5,mfrow=c(1,2))
plot(test[,1:2],col=as.character(test[,3]),pch="~")
points(train[,1:2],col=as.character(train[,3]),pch=18,cex=1.2)
plot(test[,1:2],col=as.character(predict(tree,test,type="class")),pch="~")

tree <- rpart(Class~.,data=train)
plotcp(tree)

tree <- rpart(Class~.,data=train,control=list(cp=0.047))
rpart.plot(tree,type=3,fallen.leaves=FALSE,box.palette=list("steelblue1","palegreen"),legend.x=0.8,legend.y=1)


## RANDOM FORESTS
set.seed(88661)
rf <- randomForest(Class~.,data=train,ntree=5000)
plot(rf)
rf
mean(predict(rf,test,type="class")!=test$Class)

par(mar=c(5,5,1,1),cex.axis=1.2,cex.lab=1.5,mfrow=c(1,2))
plot(test[,1:2],col=as.character(test[,3]),pch="~")
points(train[,1:2],col=as.character(train[,3]),pch=18,cex=1.2)
plot(test[,1:2],col=as.character(predict(rf,test,type="class")),pch="~")


phobia <- read.table("https://drive.switch.ch/index.php/s/5HiEn1NDoAbEci4/download",header=TRUE,as.is=FALSE)

set.seed(999)
rf.phobia <- randomForest(acrophobia~.,data=phobia,ntree=1000)
rf.phobia

par(mar=c(5,5,1,1),cex.axis=1.5,cex.lab=1.5)
varImpPlot(rf.phobia,pch=18,main="")



