function [VBSSM]=EM_ShumStoff_HAAR_sezen(signalTOT_PP,cyc,p,decalage,scaleSTART,scalemax,ap)

%--------------------------------------------------------------------------
% X    (chans x N) timeseries matrix. 
% len 	len is the length of one epoch (default = size(X,2))       
% p   	MAR model order
% cyc 	Maximum number of cycles
% tol   Tolerance criterion

[X,Y] = matrices_construction(signalTOT_PP);
len=size(signalTOT_PP,2); chans=size(signalTOT_PP,1); N=size(signalTOT_PP,3);
k=(sum(p))*chans^2; pmax=p(length(p));


%k est fonction du nombre de scales utilises
% k=(sum(p(scaleSTART:scale+1)))*chans^2;
k=(sum(p))*chans^2;
T=len-(pmax*2^(scalemax)+decalage);

%---------------------------------------------
%INITIALISATIONS
%---------------------------------------------

P0=eye(k)*0.1;  x0=ones(k,1)*0.1;
R=kron(eye(chans),eye(N));
Q=eye(k)*0.01; 
A=eye(k)*ap;

for i=1:chans*N
   HAAR(:,:,i)=atrouwhaar(X(i,:),scalemax);
end


for cycle=1:cyc,

%--------------------------------------------------------------------------
% E-STEP
%--------------------------------------------------------------------------
     
% SIMPLE RTS
%----------------------------------------------
 [Xfin,Pfin,Pcov,Xpre,Ppre]=vksm_sezen_HAAR(Y,X,x0,P0,A,Q,R,p,pmax,decalage,T,scaleSTART,scalemax,k,HAAR,N);

% MEAN E-STEP ON ALL TRIALS
%----------------------------------------------   
for j=1:N
    YXX=0; yj=[]; Cj=[];
    for t=1:T
       yj=[]; Cj=[];
        [y,C]=cmat_sezen_HAAR(Y,X,t,p,pmax,decalage,scaleSTART,scalemax,HAAR,N);
        for i=1:chans
             yj=[yj;y((i-1)*N+j,:)];
             Cj=[Cj;C((i-1)*N+j,:)];
        end
        YXX=YXX+(yj-Cj*Xfin(:,t))*(yj-Cj*Xfin(:,t))'+Cj*Pfin(:,:,t)*Cj';
    end
    YX(:,:,j)=YXX;
end


%----------------------------------
A3=0;
for t=2:T
    term=Pfin(:,:,t)+Xfin(:,t)*Xfin(:,t)';
    A3=A3+term;
end
%----------------------------------
A2=0;
for t=1:T-1
    term=Pfin(:,:,t)+Xfin(:,t)*Xfin(:,t)';
    A2=A2+term;
end
%----------------------------------
A1=0;
for t=2:T
    term=Pcov(:,:,t)+Xfin(:,t)*Xfin(:,t-1)';
    A1=A1+term;
end
%----------------------------------
    
% M STEP
%-------------------------------------------------------------------------

% A 
A=diag(diag(A1*pinv(A2))); 

% Q
Q=(1/(T-1))*diag(diag(A3-A1*pinv(A2)*A1')); 

% R


R=zeros(chans*N,chans*N);

for j=1:N
    R(chans*j-(chans-1):chans*j,chans*j-(chans-1):chans*j)=YX(:,:,j)./T;
end


%----------------------------%----------------------------
% UPDATE HYPERPARAMETERS
%----------------------------%----------------------------

Perr=(Xfin(:,1)-x0)*(Xfin(:,1)-x0)';
x0 = Xfin(:,1);
P0= Pfin(:,:,1)+Perr;

end


%----------------------------
% VBSSM STRUCTURE BUILDING
%----------------------------
VBSSM.x0=x0;
VBSSM.P0=P0;
VBSSM.A=A; VBSSM.Q=Q; VBSSM.R=R; 
