function [Xfin,Pfin,Pcov,Xpre,Ppre]=vksm_sezen_HAAR(Y,X,x0,P0,A,Q,R,p,pmax,decalage,T,scaleSTART,scalemax,k,HAAR,N)


% INITIALISATIONS MATRICES
%----------------------------------------------
chans=size(X,1)/N; 
Xpre=zeros(k,T); Xcur=zeros(k,T);
Ppre=zeros(k,k,T);Pcur=zeros(k,k,T);
Xfin=zeros(k,T); Pfin=zeros(k,k,T); Pcov=zeros(k,k,T);
%----------------------------------------------

Xcur(:,1)=x0;Pcur(:,:,1)=P0;
Xpre(:,1)=x0; Ppre(:,:,1)=P0;

%----------------------------------------------
% INITIALISATION CHIAPPA
%----------------------------------------------
[y,C]=cmat_sezen_HAAR(Y,X,1,p,pmax,decalage,scaleSTART,scalemax,HAAR,N);

Pzz=C*Pcur(:,:,1)*C'+R;
K=Pcur(:,:,1)*C'*inv(Pzz);
IKB=eye(k)-K*C;
Ppre(:,:,1)=IKB*Pcur(:,:,1)*IKB'+K*R*K';
if (~isequal(Ppre(:,:,1),Ppre(:,:,1)'))
   Ppre(:,:,1)=(Ppre(:,:,1)+Ppre(:,:,1)')/2;
end
Xpre(:,1)=Xcur(:,1)+K*(y-C*Xcur(:,1)); 



% FORWARD
%----------------------------------------------
for t=2:T,       

   [y,C]=cmat_sezen_HAAR(Y,X,t,p,pmax,decalage,scaleSTART,scalemax,HAAR,N);
% --------------------------------------------------------------
      
%   [v,s]=eig(Pcur(:,:,t));
%    eigsum=zeros(k,k);
%    for j=1:k,
%        eigsum=eigsum+s(j,j)*kron(v(:,j)',eye(k))*eye(k^2)'*kron(v(:,j),eye(k));
%    end
   Ppre(:,:,t)=A*Pcur(:,:,t-1)*A'+Q;   %+eigsum;        
   temp=R+C*Ppre(:,:,t)*C';
   ti=inv(temp);
   Kcur=Ppre(:,:,t)*C'*ti;
   KC=Kcur*C;
%-------------------------------   
   Pcur(:,:,t)=(eye(k)-KC)*Ppre(:,:,t)*(eye(k)-KC)'+Kcur*R*Kcur'; 
%  Pcur(:,:,t)=Ppre(:,:,t)-KC*Ppre(:,:,t);
    if (~isequal(Pcur(:,:,t),Pcur(:,:,t)'))
        Pcur(:,:,t)=(Pcur(:,:,t)+Pcur(:,:,t)')/2;
    end
%-------------------------------     
   
    Xpre(:,t)=A*Xcur(:,t-1); 

   % filtered expectation and covariance updates, Joseph's form
   % -------------------------------
   Xcur(:,t)=Xpre(:,t)+Kcur*(y-C*Xpre(:,t));    

end


% BACKWARD
%----------------------------------------------

Xfin(:,T)=Xcur(:,T); Pfin(:,:,T)=Pcur(:,:,T);

% filter recursion
% -------------------------------------------------------------------------

Pcov(:,:,T)=(eye(k)-KC)*A*Pcur(:,:,T-1);

for t=(T-1):-1:1,
       % -------------------------------
    J(:,:,t)=Pcur(:,:,t)*A'*inv(Ppre(:,:,t+1)); 
    Xfin(:,t)=Xcur(:,t)+J(:,:,t)*(Xfin(:,t+1)-A*Xcur(:,t));
%-------------------------------%-------------------------------
%----------------------- CHIAPPA CODE---------------------------    
%     tmp=eye(k)-J(:,:,t)*A;
%     Pfin(:,:,t)=tmp*Pcur(:,:,t)*tmp'+J(:,:,t)*Q*J(:,:,t)'+J(:,:,t)*Pfin(:,:,t+1)*J(:,:,t)';
%     if (~isequal(Pfin(:,:,t),Pfin(:,:,t)'))
%         Pfin(:,:,t)=(Pfin(:,:,t)+Pfin(:,:,t)')/2;
%     end
%-------------------------------%-------------------------------
%----------------------- PENNY CODE---------------------------  
    Pfin(:,:,t)=Pcur(:,:,t)+J(:,:,t)*(Pfin(:,:,t+1)-Ppre(:,:,t+1))*J(:,:,t)';      

end

 
for t=(T-1):-1:2,
    % -------------------------------
    % ------------------------ Penny    
     Pcov(:,:,t)=(Pcur(:,:,t)+J(:,:,t-1)'*(Pcov(:,:,t+1)-A*Pcur(:,:,t)))*J(:,:,t-1)';
    % ------------------------ OSTWALD    
%     Pcov(:,:,t)=J(:,:,t)*Pfin(:,:,t+1);
    % -------------------------------
end

end

 