function [KL]=KL_gammaMOI(q1,q2,p1,p2,k)

% ---------------------------------------------------------------
%----------------------------------------------------------------
% Calculates KL(q||p)=<ln q(x)/p(x)>_q(x) 
% q and p are Gamma distributions with parameters q1,q2 and p1,p2.
%----------------------------------------------------------------
%----------------------------------------------------------------

q1=q1.*ones(1,k);
p1=p1.*ones(1,k);


for i=1:k
    
%----------------%----------------%----------------%----------------
% ENTROPY
% KL(i)=log_gen_gamma(1,q1(i))-(q1(i)-1)*digamma+q1(i)+log(q2(i))+q1(i); % Bishop p.688
% ----------------%----------------%----------------%----------------
        
%         digamma=mfun('Psi',q1(i));
        digamma=psi(q1(i));
        KL(i)=q1(i)*log(q2(i))-p1(i)*log(p2(i))-gammaln(q1(i))+gammaln(p1(i))+(q1(i)-p1(i))*(digamma-log(q2(i)))-q1(i)*(1-p2(i)/q2(i)); 
%         KL(i)=(q1(i)-p1(i))*digamma-gammaln(q1(i))+gammaln(p1(i))+q1(i)*(-log(q2(i))+log(q1(i)))+q1(i)*(q2(i)/(p2(i)-q2(i))); 
end

KL=sum(KL);

end

