%--------------------------------------------------------------------------
% Toolbox MSGranger, version 0.501, 29 July, 2 files.
%--------------------------------------------------------------------------

%--------------------------------------------------------------------------
% LOAD THE DATA : [nChans (chans) x nTtimepoints (T) x nTrials (Ntot)]
%--------------------------------------------------------------------------
clear all; close all;
load('signalTOT.mat');

%--------------------------------------------------------------------------
% Defines the maximal and the minimal frequencies u want to look at + srate
%--------------------------------------------------------------------------
frq_max=125; frq_min=30; s_rate=1152;

%--------------------------------------------------------------------------
% Preprocessing: Standardization over the trials (gd mean and/or gd std) 
%--------------------------------------------------------------------------
[signalTOT_PP] = preprocessing(signalTOT,2);

%--------------------------------------------------------------------------
% Model order and scales selection
%--------------------------------------------------------------------------
[pfinal]=model_order_selection(signalTOT_PP,frq_max,frq_min,s_rate)

% -------------------------------------------------------------------------
% MSBSS estimation
% -------------------------------------------------------------------------
[XfinHAAR,PfinHAAR,Ftot,VBSSMHAAR]=MSBSSM(signalTOT_PP,pfinal,0.9,1,1,10);
% -------------------------------------------------------------------------
% Compute total Granger causality statistic
% -------------------------------------------------------------------------
[STAT_TOT,STATHAAR_TOT] = GC_STATS(XfinHAAR,PfinHAAR,pfinal);

% -------------------------------------------------------------------------
% Plot the Granger-causal statistics
% -------------------------------------------------------------------------
plot_GC_STATS(XfinHAAR,STAT_TOT,STATHAAR_TOT,pfinal,signalTOT_PP,s_rate);

% -------------------------------------------------------------------------
% save the results
% -------------------------------------------------------------------------
saveTOT(XfinHAAR,PfinHAAR,VBSSMHAAR,signalTOT_PP,pfinal);


%--------------------------------------------------------------------------
% Details on functions 
%--------------------------------------------------------------------------

% preprocessing.m
%--------------------------------------------------------------------------

% Function arguments
%--------------------------------------------------------------------------
% signalTOT:    Data
% type == 0:    no preprocessing
% type == 1:    remove the grand mean (for each node at each time: 
%               remove the mean  accross trials)
% type == 2:    remove the grand mean and divide by the grand sd (for each 
%               node at each time: remove the mean  accross trials and 
%               divide by the grand sd accross trials)
%--------------------------------------------------------------------------
% Output:
%--------------------------------------------------------------------------
% signalTOT_PP: Preprocessed signal
%--------------------------------------------------------------------------

% model_order_selection.m
%--------------------------------------------------------------------------

% Function arguments:
%--------------------------------------------------------------------------
% frq_max:      The highest frequency needed in the estimation
% frq_min:      The minimal frequency needed in the estimation
% s_rate:       The sampling rate of the signal
% pmaxscale:    Fix the maximum p by scale
% -------------------------------------------------------------------------
% Output:
%--------------------------------------------------------------------------
% pfinal:      Selected model order
% -------------------------------------------------------------------------

% MSBSSM.m
%--------------------------------------------------------------------------
% Function arguments:
%--------------------------------------------------------------------------
% signalTOT_PP: [chans x T x N] preprocessed signal 
% p             Model order
% ap            Prior value for the transition matrix A
% pmax:         Model order selected for the smooth
% decalage:     Defines the decalage between y_t and y_{t-1}
% tol:          Critertion for convergence of the EM algorithm 
% cycl:         Maximum number of iterations of the EM algorithm  
%--------------------------------------------------------------------------
% Outputs:
%--------------------------------------------------------------------------
% Xfin:         Time-varying VAR coefficients (see Cekic et al. (2019))
% Pfin:         Var_cov matrix of the time-varying VAR coefficients
% Ftot:         Free energy value 
% VBSSM:        Structure with all the Bayesian estimated parameters 
%               (see Cekic et al. (2019) for more details).
% p:            The model order 
%--------------------------------------------------------------------------

        