function mat = atrouwhaar (x, n)
% Comupute the Haar a trou with n wavelet levels and 1 scale level
% => n+1 lines
% The first (2^ilev)-1 values (which sould depend on border) are not
% credible

s = length(x);
if (2^(n-1)-1 >= s) 
    error('nblevel too high compared to length of x')
end

evenoddVal = 0;
evenLEN    = 1;
swd = zeros(n,s);
swa = zeros(n,s);
[lo,hi] = wfilters('haar','d');
for k = 1:n
    % Decomposition.
    swd(k,:) = wkeep1(wconv1(x,hi),s,'l');
    swa(k,:) = wkeep1(wconv1(x,lo),s,'l');

    % upsample filters.
    lo = dyadup(lo,evenoddVal,evenLEN);
    hi = dyadup(hi,evenoddVal,evenLEN);

    % New value of x.
    x = swa(k,:);

end
mat = [swd ; swa(n,:)];