function [pfinal]=model_order_selection(signalTOT_PP,frq_max,frq_min,s_rate,pmaxscale)

%--------------------------------------------------------------------------
%  Model order selection: selection of p_j scale by scale: backward
%  seletion
%--------------------------------------------------------------------------
% Function arguments:
%--------------------------------------------------------------------------
% frq_max:      The highest frequency needed in the estimation
% frq_min:      The minimal frequency needed in the estimation
% s_rate:       The sampling rate of the signal
% pmaxscale:    Fix the maximum p by scale
% -------------------------------------------------------------------------

%--------------------------------------------------------------------------
% Output:
%--------------------------------------------------------------------------
% pfinal:      Selected model order
% -------------------------------------------------------------------------

if nargin <5
     pmaxscale = 2;
end
fprintf(' Define minimal and maximal scale\n');

%-----------------------------------
% Scale to frequecy: 
%-----------------------------------
scalemax=ceil(log(s_rate/frq_min)/log(2))
freq=round(scal2frq(2.^(1:scalemax),'haar',1/(s_rate)));
scale_min=max(find(freq >= frq_max))
%-----------------------------------------------------------------

%-----------------------------------
% Search the opimal model order on the median between the trials 
%-----------------------------------

signalMED=median(signalTOT_PP,3);

% Initialize the matrix for p [1 x scales]
Ftot_scales_TOT     =zeros(scalemax+1,pmaxscale+1);
Ftot_scales         =zeros(1,pmaxscale);

ptest(scalemax+1)=1; % model order for the smooth is fixed to 1
for s=scalemax:-1:scale_min
    for porder=1:pmaxscale
        ptest(s)=porder

        [Xfin,Pfin,Ftot,VBSSM]=MSBSSM(signalTOT_PP,ptest);
        Ftot_scales(porder)=Ftot;
    end
    ptest(s)= find(Ftot_scales == max(Ftot_scales));   
    Ftot_scales_TOT(s,1:pmaxscale)=Ftot_scales;
    clear Ftot_scales
end

% for s = scale_min-1 : -1 :1
%     for porder=0:pmaxscale
%         ptest(s)= porder
%         [Xfin,Pfin,Ftot,VBSSM]=MSBSSM_select(signalTOT_PP,ptest,0.9,1,1,0.01,10);
%         Ftot_scales(porder+1)=Ftot;
%     end
%     ptest(s)= find(Ftot_scales == max(Ftot_scales))-1; 
%         if find(Ftot_scales == max(Ftot_scales))== 1
%             pfinal=ptest;
%             Ftot_scales_TOT(s,1:pmaxscale+1)=Ftot_scales;
%             break;
%         else
%             Ftot_scales_TOT(s,1:pmaxscale+1)=Ftot_scales;
%             clear Ftot_scales
%         end
% end

pfinal=ptest;

