function plot_GC_STATS(XfinHAAR,STAT_TOT,STATHAAR_TOT,pfinal,signalTOT_PP,s_rate)

% -------------------------------------------------------------------------
% Plot the time-varying AR coefficients
% -------------------------------------------------------------------------
chans=size(signalTOT_PP,1);
sizeSIGNAL=size(signalTOT_PP,2); Ntot=size(signalTOT_PP);
sizeXFINHAAR=size(XfinHAAR,2);
scales=find(pfinal~=0);pfin=pfinal(scales);
scale_min=min(find(pfinal ~= 0)); scalemax = length(pfinal)-1;

% -------------------------------------------------------------------------
% Scale to frequency legend
% -------------------------------------------------------------------------
freq=round(scal2frq(2.^(1:scalemax),'haar',1/(s_rate)));
for i=1:scalemax-scale_min+1
    frq_names(i)=freq(i+scale_min-1);
end
legendCell = cellstr(num2str(frq_names', '%dHz'));
legendCell{scalemax-scale_min+2}='Lower frequencies';


% -------------------------------------------------------------------------
% Plot time-varying VAR coefficients
% -------------------------------------------------------------------------

figure()
plot(XfinHAAR')
title('Time-varying VAR coefficients')
%--------------------------------------------------------------
vline(120-(sizeSIGNAL-sizeXFINHAAR),'green'); % onset
vline((120+10)-(sizeSIGNAL-sizeXFINHAAR),'red'); % 5ms after onset
vline((120+50)-(sizeSIGNAL-sizeXFINHAAR),'red'); % 25ms after onset
xlim([0 sizeXFINHAAR])

 
%--------------------------------------------------------------------------
% Plot total chi Square Statistic
%--------------------------------------------------------------------------

figure('Name','Total_chi_square_statistic','NumberTitle','off');

k=1; clear STAT_TOT_INFL
for i=1:chans
    for j=1:chans
        if i~=j
        channel=j; channel_CAUSE=i; 
        
        % Statistic
        %-----------------------------------------------------------------
        clear STAT;             
        STAT=squeeze(STAT_TOT(i,j,:));            
        subplot(chans, chans-1 ,k)
        format='Test %d->%d';
        name=sprintf(format,i,j);
        plot(STAT','LineWidth',2)
        title(name)
        M=max(max(max(STAT_TOT)));
        xlim([0 size(STAT_TOT,3)])
        ylim([0 M+50])
        %-----------------------------------------------------------------
        vline(120-(sizeSIGNAL-sizeXFINHAAR),'green','Onset'); % onset
        vline((120+10)-(sizeSIGNAL-sizeXFINHAAR),'red'); % 5ms after onset
        vline((120+50)-(sizeSIGNAL-sizeXFINHAAR),'red','Plausible latencies'); % 25ms after onset
              
        k=k+1;
        end
    end
end

%--------------------------------------------------------------------------
% Plot scale specific  chi Square Statistic
%--------------------------------------------------------------------------
figure('Name','Scale_specific_statistic','NumberTitle','off');

k=1; clear STAT_TOT_INFL
for i=1:chans
    for j=1:chans
        if i~=j
            for p=min(scales):max(scales)               
                channel=j; channel_CAUSE=i; 
                STAT=squeeze(STATHAAR_TOT(i,j,p,:));            
                subplot(chans, chans-1 ,k)
                plot(STAT','LineWidth',2),hold on

            end
            
            format='Test %d->%d';
            name=sprintf(format,i,j);
            title(name)
            
            
            M=max(max(max(max(STATHAAR_TOT(:,:,:,:)))));
            xlim([0 size(STATHAAR_TOT,4)])
            ylim([0 M+50])
            %--------------------------------------------------------------
            vline(120-(sizeSIGNAL-sizeXFINHAAR),'green','Onset'); % onset
            vline((120+10)-(sizeSIGNAL-sizeXFINHAAR),'red'); % 5ms after onset
            vline((120+50)-(sizeSIGNAL-sizeXFINHAAR),'red','Plausible latencies'); % 25ms after onset
            
            k=k+1;
        end
    end
end

legend(legendCell)
set(legend,'position', [0, 0, .25, .25],'FontSize',20)
set(gca, 'FontSize',7);
set(gcf, 'PaperPositionMode', 'auto')
%--------------------------------------------------------------------------





