function [signalTOT_PP]=preprocessing(signalTOT,type)

%--------------------------------------------------------------------------
% Preprocessing of the signal
%--------------------------------------------------------------------------
% type == 0:    no preprocessing
% type == 1:    remove the grand mean (for each node at each time: 
%               remove the mean  accross trials)
% type == 2:    remove the grand mean and divide by the grand sd (for each 
%               node at each time: remove the mean  accross trials and 
%               divide by the grand sd accross trials)
%--------------------------------------------------------------------------
% Output:
%--------------------------------------------------------------------------
% signalTOT_PP: Preprocessed signal
%--------------------------------------------------------------------------

signalTOT_PP=zeros(size(signalTOT)); chans=size(signalTOT,1); T=size(signalTOT,2); 

if type == 0 
    signalTOT_PP = signalTOT;
    
elseif type ==1 
    
    for i=1:chans
        for t=1:T
           M=mean(signalTOT(i,t,:));
           signalTOT_PP(i,t,:)=(signalTOT(i,t,:)-M);
        end
    end

elseif type ==2   
    
        for i=1:chans
            for t=1:T
               M=mean(signalTOT(i,t,:));
               SD=std(signalTOT(i,t,:));
               signalTOT_PP(i,t,:)=(signalTOT(i,t,:)-M)/SD;
            end
        end
    
end

figure()
subplot(2,1,1)
plot(signalTOT(:,:,1)')
title(['Signal for all channels Trial 1'])

subplot(2,1,2)
plot(signalTOT_PP(:,:,1)')
title(['Preprocessed signal for all channels Trial 1'])